/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangeIndexTranslator
extends AbstractTranslator {
    private final Translator translator;
    private final String field;
    private List<String> fields;
    private final Map<String, String> index = new HashMap<String, String>();

    @Override
    public String getLinkInfo(String translatedId, String field) {
        return this.translator.getLinkInfo(translatedId, field);
    }

    @Override
    public boolean isLinkInfo(String field) {
        return this.translator.isLinkInfo(field);
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public String translateField(String id, String field) {
        return this.translator.translateField(id, field);
    }

    private void makeIndex() {
        List<String> ids = this.translator.getIds();
        if (ids == null) {
            return;
        }
        for (String id : ids) {
            String t = this.translator.translateField(id);
            if (t == null || this.index.containsKey(t)) continue;
            this.index.put(t, id);
        }
        List<String> fs = this.translator.getFields();
        this.fields = new ArrayList<String>();
        for (String f : fs) {
            if (this.field.equals(f)) continue;
            this.fields.add(f);
        }
    }

    public ChangeIndexTranslator(Translator translator, String field) {
        if (translator == null) {
            throw new NullPointerException("Translator is null");
        }
        if (field == null) {
            throw new NullPointerException("The field is null");
        }
        if (!translator.isField(field)) {
            throw new NullPointerException("The field " + field + " doesn't exist in the translator");
        }
        this.translator = translator;
        this.field = field;
        this.makeIndex();
    }
}

