/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonLinksInfoTranslator
extends AbstractTranslator {
    private final Translator translator;
    private final Map<String, String> mapLinks = new HashMap<String, String>();

    @Override
    public List<String> getFields() {
        return this.translator.getFields();
    }

    @Override
    public String translateField(String id, String field) {
        return this.translator.translateField(id, field);
    }

    @Override
    public boolean isLinkInfo(String field) {
        return this.mapLinks.containsKey(field);
    }

    @Override
    public String getLinkInfo(String translatedId, String field) {
        if (translatedId == null || field == null) {
            throw new NullPointerException("field and translateId arguments can't be null.");
        }
        if (this.mapLinks.containsKey(field)) {
            String EncodedTranslatedId = translatedId;
            try {
                EncodedTranslatedId = URLEncoder.encode(translatedId, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            return this.mapLinks.get(field).replace("${ID}", EncodedTranslatedId);
        }
        return null;
    }

    @Override
    public List<String> getIds() {
        return this.translator.getIds();
    }

    public void add(String field, String link) {
        if (link == null || field == null) {
            throw new NullPointerException("field and link arguments can't be null.");
        }
        this.mapLinks.put(field, link);
    }

    public void remove(String field) {
        if (field == null) {
            throw new NullPointerException("field argument can't be null.");
        }
        this.mapLinks.remove(field);
    }

    public void clear() {
        this.mapLinks.clear();
    }

    public void load(File in) throws IOException {
        if (in == null) {
            throw new NullPointerException("file argument can't be null.");
        }
        this.load(new FileInputStream(in));
    }

    public void load(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in argument can't be null.");
        }
        this.load(new InputStreamReader(in));
    }

    public void load(Reader in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in argument can't be null.");
        }
        BufferedReader reader = new BufferedReader(in);
        String line = "";
        while ((line = reader.readLine()) != null) {
            int pos = line.indexOf(61);
            if (pos == -1) continue;
            String field = line.substring(0, pos).trim();
            String link = line.substring(pos + 1).trim();
            if (link.isEmpty()) {
                this.remove(field);
                continue;
            }
            this.add(field, link);
        }
    }

    public CommonLinksInfoTranslator(Translator translator) {
        if (translator == null) {
            throw new NullPointerException("Translator can't be null");
        }
        try {
            this.load(this.getClass().getResourceAsStream("/META-INF/commonlinks.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.translator = translator;
    }
}

