/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConcatTranslator
extends AbstractTranslator {
    private final Map<String, Translator> translators = new LinkedHashMap<String, Translator>();

    @Override
    public List<String> getFields() {
        return new ArrayList<String>(this.translators.keySet());
    }

    @Override
    public String translateField(String id, String field) {
        Translator t = this.translators.get(field);
        if (t == null) {
            throw new NullPointerException("Associated Translator t is null.");
        }
        return t.translateField(id, field);
    }

    @Override
    public boolean isLinkInfo(String field) {
        Translator t = this.translators.get(field);
        if (t == null) {
            return false;
        }
        return t.isLinkInfo(field);
    }

    @Override
    public String getLinkInfo(String translatedId, String field) {
        Translator t = this.translators.get(field);
        if (t == null) {
            return null;
        }
        return t.getLinkInfo(translatedId, field);
    }

    public void addTranslator(Translator translator) {
        if (translator == null) {
            return;
        }
        List<String> fields = translator.getFields();
        if (fields == null) {
            return;
        }
        for (String key : fields) {
            if (this.translators.containsKey(key)) continue;
            this.translators.put(key, translator);
        }
    }

    public ConcatTranslator() {
    }

    public ConcatTranslator(Translator translator1, Translator translator2) {
        this.addTranslator(translator1);
        this.addTranslator(translator2);
    }
}

