/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoinTranslator
extends AbstractTranslator {
    private final Translator translator1;
    private final Translator translator2;
    private String joinField;
    private final List<String> fields;
    private final Map<String, Translator> mapTranslator = new HashMap<String, Translator>();
    private final boolean returnTranslation1IfNoTranslation;

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public String translateField(String id, String field) {
        Translator t = this.mapTranslator.get(field);
        if (t == null) {
            throw new NullPointerException("Associated Translator is null.");
        }
        if (t == this.translator1) {
            return this.translator1.translateField(id, field);
        }
        String result1 = this.translator1.translateField(id, this.joinField);
        String result = this.translator2.translateField(result1, field);
        if (result == null && this.returnTranslation1IfNoTranslation) {
            return result1;
        }
        return result;
    }

    @Override
    public boolean isLinkInfo(String field) {
        Translator t = this.mapTranslator.get(field);
        if (t == null) {
            return false;
        }
        if (t == this.translator1) {
            return this.translator1.isLinkInfo(field);
        }
        return this.translator2.isLinkInfo(field);
    }

    @Override
    public String getLinkInfo(String translatedId, String field) {
        Translator t = this.mapTranslator.get(field);
        if (t == null) {
            return null;
        }
        if (t == this.translator1) {
            return this.translator1.getLinkInfo(translatedId, field);
        }
        return this.translator2.getLinkInfo(translatedId, field);
    }

    public JoinTranslator(Translator translator1, String joinField, Translator translator2) {
        this(translator1, joinField, translator2, false);
    }

    public JoinTranslator(Translator translator1, String joinField, Translator translator2, boolean returnTranslation1IfNoTranslation) {
        if (translator1 == null) {
            throw new NullPointerException("Translator1  can't be null");
        }
        if (translator2 == null) {
            throw new NullPointerException("Translator1  can't be null");
        }
        if (joinField == null) {
            throw new NullPointerException("Join field  can't be null");
        }
        if (!translator1.isField(joinField)) {
            throw new NullPointerException("The join field isn't in translator 1");
        }
        this.translator1 = translator1;
        this.translator2 = translator2;
        this.returnTranslation1IfNoTranslation = returnTranslation1IfNoTranslation;
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String f : translator1.getFields()) {
            this.mapTranslator.put(f, translator1);
            fieldList.add(f);
        }
        for (String f : translator2.getFields()) {
            if (this.mapTranslator.containsKey(f)) continue;
            this.mapTranslator.put(f, translator2);
            fieldList.add(f);
        }
        this.fields = Collections.unmodifiableList(fieldList);
    }
}

