/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator;

import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.translator.AbstractTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiColumnTranslator
extends AbstractTranslator {
    private final Map<String, Map<String, String>> annotations = new HashMap<String, Map<String, String>>();
    private List<String> fieldNames;

    public void addRow(List<String> rowData) {
        if (rowData == null || rowData.size() == 0 || rowData.size() == 1) {
            return;
        }
        List<String> dataArray = this.arrayWithoutFirstElement(rowData);
        this.addRow(rowData.get(0), dataArray);
    }

    public void addRow(String ... rowData) {
        if (rowData == null) {
            return;
        }
        this.addRow(Arrays.asList(rowData));
    }

    public void addRow(String id, List<String> rowData) {
        if (id == null || rowData == null) {
            return;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        int sizeData = rowData.size();
        int sizeFields = this.fieldNames.size();
        int size = Math.min(sizeData, sizeFields);
        for (int i = 0; i < size; ++i) {
            dataMap.put(this.fieldNames.get(i), rowData.get(i));
        }
        this.annotations.put(id, dataMap);
    }

    @Override
    public List<String> getFields() {
        if (this.fieldNames == null) {
            return null;
        }
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public String translateField(String id, String fieldName) {
        if (id == null) {
            return null;
        }
        String field = fieldName == null ? this.getDefaultField() : fieldName;
        Map<String, String> map = this.annotations.get(id);
        if (map == null) {
            return null;
        }
        return map.get(field);
    }

    public void clear() {
        this.annotations.clear();
    }

    private List<String> arrayWithoutFirstElement(List<String> data) {
        if (data == null) {
            return null;
        }
        return Collections.unmodifiableList(data.subList(1, data.size()));
    }

    @Override
    public List<String> getIds() {
        return new ArrayList<String>(this.annotations.keySet());
    }

    public MultiColumnTranslator(List<String> fieldNames) {
        this(fieldNames, true);
    }

    public MultiColumnTranslator(List<String> fieldNames, boolean fieldNamesWithId) {
        if (fieldNames == null) {
            throw new NullPointerException("fieldnames is null");
        }
        if (fieldNamesWithId && fieldNames.size() < 2) {
            throw new KenetreRuntimeException("fieldNames must have at least 2 fields");
        }
        if (!fieldNamesWithId && fieldNames.size() < 1) {
            throw new KenetreRuntimeException("fieldNames must have at least one fields");
        }
        if (fieldNamesWithId) {
            this.fieldNames = this.arrayWithoutFirstElement(fieldNames);
            this.setDefaultField(fieldNames.get(1));
        } else {
            this.fieldNames = fieldNames;
            this.setDefaultField(fieldNames.get(0));
        }
    }

    public MultiColumnTranslator(String ... fieldNames) {
        this(Arrays.asList(fieldNames));
    }
}

