/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator.io;

import fr.ens.biologie.genomique.kenetre.translator.MultiColumnTranslator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiColumnTranslatorReader {
    private InputStream is;
    private BufferedReader bufferedReader;
    private static final String SEPARATOR = "\t";
    private boolean removeQuotes = true;
    private final boolean noHeader;

    protected InputStream getInputStream() {
        return this.is;
    }

    protected BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    protected String getSeparatorField() {
        return SEPARATOR;
    }

    public boolean isRemoveQuotes() {
        return this.removeQuotes;
    }

    protected void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    protected void setInputStream(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No stream to read");
        }
        this.is = is;
    }

    public void setRemoveQuotes(boolean removeQuotes) {
        this.removeQuotes = removeQuotes;
    }

    public MultiColumnTranslator read() throws IOException {
        this.setBufferedReader(new BufferedReader(new InputStreamReader(this.getInputStream(), Charset.defaultCharset())));
        boolean removeQuotes = this.isRemoveQuotes();
        BufferedReader br = this.getBufferedReader();
        String separator = this.getSeparatorField();
        String line = null;
        MultiColumnTranslator result = null;
        while ((line = br.readLine()) != null) {
            if ("".equals(line)) continue;
            ArrayList<String> cols = new ArrayList<String>(Arrays.asList(line.split(separator)));
            if (removeQuotes) {
                for (int i = 0; i < cols.size(); ++i) {
                    cols.set(i, MultiColumnTranslatorReader.removeDoubleQuotesAndTrim((String)cols.get(i)));
                }
            }
            if (result == null && this.noHeader) {
                ArrayList<String> header = new ArrayList<String>(cols.size());
                for (int i = 0; i < header.size(); ++i) {
                    header.add("#" + i);
                }
                result = new MultiColumnTranslator(header);
            }
            if (result == null) {
                result = new MultiColumnTranslator(cols);
                continue;
            }
            result.addRow(cols);
        }
        return result;
    }

    private static String removeDoubleQuotes(String s) {
        if (s == null) {
            return null;
        }
        String result = s;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String removeDoubleQuotesAndTrim(String s) {
        if (s == null) {
            return null;
        }
        return MultiColumnTranslatorReader.removeDoubleQuotes(s.trim());
    }

    public MultiColumnTranslatorReader(String filename) throws IOException {
        this(new File(filename), false);
    }

    public MultiColumnTranslatorReader(String filename, boolean noHeader) throws IOException {
        this(new File(filename), noHeader);
    }

    public MultiColumnTranslatorReader(File file) throws IOException {
        this(file, false);
    }

    public MultiColumnTranslatorReader(File file, boolean noHeader) throws IOException {
        if (file == null) {
            throw new IOException("No file to load");
        }
        this.noHeader = noHeader;
        this.setInputStream(new FileInputStream(file));
    }

    public MultiColumnTranslatorReader(InputStream is) throws IOException {
        this(is, false);
    }

    public MultiColumnTranslatorReader(InputStream is, boolean noHeader) throws IOException {
        this.noHeader = noHeader;
        this.setInputStream(is);
    }
}

