/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.translator.io;

import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class TSVTranslatorOutputFormat
implements TranslatorOutputFormat {
    private final BufferedWriter writer;
    private boolean startOfLine = true;

    @Override
    public void addHeaderField(String fieldName) throws IOException {
        if (this.startOfLine) {
            this.startOfLine = false;
        } else {
            this.writer.write(9);
        }
        this.writer.write(fieldName);
    }

    @Override
    public void newLine() throws IOException {
        this.writer.write(10);
        this.startOfLine = true;
    }

    @Override
    public void writeEmpty() throws IOException {
        if (this.startOfLine) {
            this.startOfLine = false;
        } else {
            this.writer.write(9);
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        if (this.startOfLine) {
            this.startOfLine = false;
        } else {
            this.writer.write(9);
        }
        this.writer.write(Long.toString(l));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        if (this.startOfLine) {
            this.startOfLine = false;
        } else {
            this.writer.write(9);
        }
        this.writer.write(Double.toString(d));
    }

    @Override
    public void writeText(String text) throws IOException {
        if (this.startOfLine) {
            this.startOfLine = false;
        } else {
            this.writer.write(9);
        }
        if (text != null) {
            this.writer.write(text);
        }
    }

    @Override
    public void writeLink(String text, String link) throws IOException {
        this.writeText(text);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public TSVTranslatorOutputFormat(OutputStream os) {
        this.writer = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));
    }

    public TSVTranslatorOutputFormat(File file) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset()));
    }
}

