/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Composite;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractComposite<T extends Container>
extends AbstractComponent<T>
implements Composite,
Container {
    private Component component = null;

    @Override
    public void setComponent(Component component) {
        Component oldComponent = this.component;
        if (oldComponent == component) {
            return;
        }
        if (oldComponent != null) {
            this.removeComponent(oldComponent);
        }
        if (component != null) {
            this.component = component;
            component.onAdded(this);
            component.setPosition(TerminalPosition.TOP_LEFT_CORNER);
            this.invalidate();
        }
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public int getChildCount() {
        return this.component != null ? 1 : 0;
    }

    @Override
    public Collection<Component> getChildren() {
        if (this.component != null) {
            return Collections.singletonList(this.component);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean containsComponent(Component component) {
        return component != null && component.hasParent(this);
    }

    @Override
    public boolean removeComponent(Component component) {
        if (this.component == component) {
            this.component = null;
            component.onRemoved(this);
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvalid() {
        return this.component != null && this.component.isInvalid();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.component != null) {
            this.component.invalidate();
        }
    }

    @Override
    public Interactable nextFocus(Interactable fromThis) {
        if (fromThis == null && this.getComponent() instanceof Interactable) {
            return (Interactable)this.getComponent();
        }
        if (this.getComponent() instanceof Container) {
            return ((Container)this.getComponent()).nextFocus(fromThis);
        }
        return null;
    }

    @Override
    public Interactable previousFocus(Interactable fromThis) {
        if (fromThis == null && this.getComponent() instanceof Interactable) {
            return (Interactable)this.getComponent();
        }
        if (this.getComponent() instanceof Container) {
            return ((Container)this.getComponent()).previousFocus(fromThis);
        }
        return null;
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        return false;
    }

    @Override
    public void updateLookupMap(InteractableLookupMap interactableLookupMap) {
        if (this.getComponent() instanceof Container) {
            ((Container)this.getComponent()).updateLookupMap(interactableLookupMap);
        } else if (this.getComponent() instanceof Interactable) {
            interactableLookupMap.add((Interactable)this.getComponent());
        }
    }
}

