/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.DefaultWindowDecorationRenderer;
import com.googlecode.lanterna.gui2.EmptyWindowDecorationRenderer;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowManager;
import java.util.List;

public class DefaultWindowManager
implements WindowManager {
    private final WindowDecorationRenderer windowDecorationRendererOverride;
    private TerminalSize lastKnownScreenSize;

    public DefaultWindowManager() {
        this(null);
    }

    public DefaultWindowManager(TerminalSize initialScreenSize) {
        this(null, initialScreenSize);
    }

    public DefaultWindowManager(WindowDecorationRenderer windowDecorationRenderer, TerminalSize initialScreenSize) {
        this.windowDecorationRendererOverride = windowDecorationRenderer;
        this.lastKnownScreenSize = initialScreenSize != null ? initialScreenSize : new TerminalSize(80, 24);
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public WindowDecorationRenderer getWindowDecorationRenderer(Window window) {
        if (window.getHints().contains(Window.Hint.NO_DECORATIONS)) {
            return new EmptyWindowDecorationRenderer();
        }
        if (this.windowDecorationRendererOverride != null) {
            return this.windowDecorationRendererOverride;
        }
        if (window.getTheme() != null && window.getTheme().getWindowDecorationRenderer() != null) {
            return window.getTheme().getWindowDecorationRenderer();
        }
        return new DefaultWindowDecorationRenderer();
    }

    @Override
    public void onAdded(WindowBasedTextGUI textGUI, Window window, List<Window> allWindows) {
        WindowDecorationRenderer decorationRenderer = this.getWindowDecorationRenderer(window);
        TerminalSize expectedDecoratedSize = decorationRenderer.getDecoratedSize(window, window.getPreferredSize());
        window.setDecoratedSize(expectedDecoratedSize);
        if (!window.getHints().contains(Window.Hint.FIXED_POSITION)) {
            if (allWindows.isEmpty()) {
                window.setPosition(TerminalPosition.OFFSET_1x1);
            } else if (window.getHints().contains(Window.Hint.CENTERED)) {
                int left = (this.lastKnownScreenSize.getColumns() - expectedDecoratedSize.getColumns()) / 2;
                int top = (this.lastKnownScreenSize.getRows() - expectedDecoratedSize.getRows()) / 2;
                window.setPosition(new TerminalPosition(left, top));
            } else {
                TerminalPosition nextPosition = allWindows.get(allWindows.size() - 1).getPosition().withRelative(2, 1);
                if (nextPosition.getColumn() + expectedDecoratedSize.getColumns() > this.lastKnownScreenSize.getColumns() || nextPosition.getRow() + expectedDecoratedSize.getRows() > this.lastKnownScreenSize.getRows()) {
                    nextPosition = TerminalPosition.OFFSET_1x1;
                }
                window.setPosition(nextPosition);
            }
        }
        this.prepareWindow(this.lastKnownScreenSize, window);
    }

    @Override
    public void onRemoved(WindowBasedTextGUI textGUI, Window window, List<Window> allWindows) {
    }

    @Override
    public void prepareWindows(WindowBasedTextGUI textGUI, List<Window> allWindows, TerminalSize screenSize) {
        this.lastKnownScreenSize = screenSize;
        for (Window window : allWindows) {
            this.prepareWindow(screenSize, window);
        }
    }

    protected void prepareWindow(TerminalSize screenSize, Window window) {
        WindowDecorationRenderer decorationRenderer = this.getWindowDecorationRenderer(window);
        TerminalSize contentAreaSize = window.getHints().contains(Window.Hint.FIXED_SIZE) ? window.getSize() : window.getPreferredSize();
        TerminalSize size = decorationRenderer.getDecoratedSize(window, contentAreaSize);
        TerminalPosition position = window.getPosition();
        if (window.getHints().contains(Window.Hint.FULL_SCREEN)) {
            position = TerminalPosition.TOP_LEFT_CORNER;
            size = screenSize;
        } else if (window.getHints().contains(Window.Hint.EXPANDED)) {
            position = TerminalPosition.OFFSET_1x1;
            size = screenSize.withRelative(-Math.min(4, screenSize.getColumns()), -Math.min(3, screenSize.getRows()));
            if (!size.equals(window.getDecoratedSize())) {
                window.invalidate();
            }
        } else if (window.getHints().contains(Window.Hint.FIT_TERMINAL_WINDOW) || window.getHints().contains(Window.Hint.CENTERED)) {
            while (position.getRow() > 0 && position.getRow() + size.getRows() > screenSize.getRows()) {
                position = position.withRelativeRow(-1);
            }
            while (position.getColumn() > 0 && position.getColumn() + size.getColumns() > screenSize.getColumns()) {
                position = position.withRelativeColumn(-1);
            }
            if (position.getRow() + size.getRows() > screenSize.getRows()) {
                size = size.withRows(screenSize.getRows() - position.getRow());
            }
            if (position.getColumn() + size.getColumns() > screenSize.getColumns()) {
                size = size.withColumns(screenSize.getColumns() - position.getColumn());
            }
            if (window.getHints().contains(Window.Hint.CENTERED)) {
                int left = (this.lastKnownScreenSize.getColumns() - size.getColumns()) / 2;
                int top = (this.lastKnownScreenSize.getRows() - size.getRows()) / 2;
                position = new TerminalPosition(left, top);
            }
        }
        window.setPosition(position);
        window.setDecoratedSize(size);
    }
}

