/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.BasicTextImage;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.gui2.AbstractBasePane;
import com.googlecode.lanterna.gui2.AbstractTextGUI;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GUIBackdrop;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.SameTextGUIThread;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.TextGUIThread;
import com.googlecode.lanterna.gui2.TextGUIThreadFactory;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.VirtualScreen;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;

public class MultiWindowTextGUI
extends AbstractTextGUI
implements WindowBasedTextGUI {
    private final VirtualScreen virtualScreen;
    private final WindowManager windowManager;
    private final BasePane backgroundPane;
    private final List<Window> windows;
    private final IdentityHashMap<Window, TextImage> windowRenderBufferCache;
    private final WindowPostRenderer postRenderer;
    private Window activeWindow;
    private boolean hadWindowAtSomePoint;
    private boolean eofWhenNoWindows;

    public MultiWindowTextGUI(Screen screen) {
        this(screen, TextColor.ANSI.BLUE);
    }

    public MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, Screen screen) {
        this(guiThreadFactory, screen, (WindowManager)new DefaultWindowManager(), null, (Component)new GUIBackdrop());
    }

    public MultiWindowTextGUI(Screen screen, TextColor backgroundColor) {
        this(screen, new DefaultWindowManager(), new EmptySpace(backgroundColor));
    }

    public MultiWindowTextGUI(Screen screen, WindowManager windowManager, Component background) {
        this(screen, windowManager, null, background);
    }

    public MultiWindowTextGUI(Screen screen, WindowManager windowManager, WindowPostRenderer postRenderer, Component background) {
        this((TextGUIThreadFactory)new SameTextGUIThread.Factory(), screen, windowManager, postRenderer, background);
    }

    public MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, Screen screen, WindowManager windowManager, WindowPostRenderer postRenderer, Component background) {
        this(guiThreadFactory, new VirtualScreen(screen), windowManager, postRenderer, background);
    }

    private MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, VirtualScreen screen, WindowManager windowManager, WindowPostRenderer postRenderer, Component background) {
        super(guiThreadFactory, screen);
        if (windowManager == null) {
            throw new IllegalArgumentException("Creating a window-based TextGUI requires a WindowManager");
        }
        if (background == null) {
            background = new EmptySpace(TextColor.ANSI.BLUE);
        }
        this.virtualScreen = screen;
        this.windowManager = windowManager;
        this.backgroundPane = new AbstractBasePane<BasePane>(){

            @Override
            public TextGUI getTextGUI() {
                return MultiWindowTextGUI.this;
            }

            @Override
            public TerminalPosition toGlobal(TerminalPosition localPosition) {
                return localPosition;
            }

            @Override
            public TerminalPosition fromGlobal(TerminalPosition globalPosition) {
                return globalPosition;
            }

            @Override
            BasePane self() {
                return this;
            }
        };
        this.backgroundPane.setComponent(background);
        this.windows = new LinkedList<Window>();
        this.windowRenderBufferCache = new IdentityHashMap();
        this.postRenderer = postRenderer;
        this.eofWhenNoWindows = false;
        this.hadWindowAtSomePoint = false;
    }

    @Override
    public synchronized boolean isPendingUpdate() {
        for (Window window : this.windows) {
            if (!window.isVisible() || !window.isInvalid()) continue;
            return true;
        }
        return super.isPendingUpdate() || this.backgroundPane.isInvalid() || this.windowManager.isInvalid();
    }

    @Override
    public synchronized void updateScreen() throws IOException {
        TerminalSize minimumTerminalSize = TerminalSize.ZERO;
        for (Window window : this.windows) {
            if (!window.isVisible() || window.getHints().contains(Window.Hint.FULL_SCREEN) || window.getHints().contains(Window.Hint.FIT_TERMINAL_WINDOW) || window.getHints().contains(Window.Hint.EXPANDED)) continue;
            TerminalPosition lastPosition = window.getPosition();
            minimumTerminalSize = minimumTerminalSize.max(window.getDecoratedSize().withRelative(Math.max(lastPosition.getColumn(), 0), Math.max(lastPosition.getRow(), 0)));
        }
        this.virtualScreen.setMinimumSize(minimumTerminalSize);
        super.updateScreen();
    }

    @Override
    protected synchronized KeyStroke readKeyStroke() throws IOException {
        KeyStroke keyStroke = super.pollInput();
        if (this.hadWindowAtSomePoint && this.eofWhenNoWindows && keyStroke == null && this.windows.isEmpty()) {
            return new KeyStroke(KeyType.EOF);
        }
        if (keyStroke != null) {
            return keyStroke;
        }
        return super.readKeyStroke();
    }

    @Override
    protected synchronized void drawGUI(TextGUIGraphics graphics) {
        this.drawBackgroundPane(graphics);
        this.getWindowManager().prepareWindows(this, Collections.unmodifiableList(this.windows), graphics.getSize());
        for (Window window : this.windows) {
            if (!window.isVisible()) continue;
            TextImage textImage = this.windowRenderBufferCache.get(window);
            if (textImage == null || !textImage.getSize().equals(window.getDecoratedSize())) {
                textImage = new BasicTextImage(window.getDecoratedSize());
                this.windowRenderBufferCache.put(window, textImage);
            }
            TextGUIGraphics windowGraphics = new TextGUIGraphics(this, textImage.newTextGraphics());
            TerminalPosition contentOffset = TerminalPosition.TOP_LEFT_CORNER;
            if (!window.getHints().contains(Window.Hint.NO_DECORATIONS)) {
                WindowDecorationRenderer decorationRenderer = this.getWindowManager().getWindowDecorationRenderer(window);
                windowGraphics = decorationRenderer.draw(this, windowGraphics, window);
                contentOffset = decorationRenderer.getOffset(window);
            }
            window.draw(windowGraphics);
            window.setContentOffset(contentOffset);
            Borders.joinLinesWithFrame(windowGraphics);
            graphics.drawImage(window.getPosition(), textImage);
            if (window.getHints().contains(Window.Hint.NO_POST_RENDERING)) continue;
            if (window.getPostRenderer() != null) {
                window.getPostRenderer().postRender(graphics, this, window);
                continue;
            }
            if (this.postRenderer != null) {
                this.postRenderer.postRender(graphics, this, window);
                continue;
            }
            if (this.getTheme().getWindowPostRenderer() == null) continue;
            this.getTheme().getWindowPostRenderer().postRender(graphics, this, window);
        }
        this.windowRenderBufferCache.keySet().retainAll(this.windows);
    }

    private void drawBackgroundPane(TextGUIGraphics graphics) {
        this.backgroundPane.draw(new TextGUIGraphics(this, graphics));
    }

    @Override
    public synchronized TerminalPosition getCursorPosition() {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.toGlobal(activeWindow.getCursorPosition());
        }
        return this.backgroundPane.getCursorPosition();
    }

    public void setEOFWhenNoWindows(boolean eofWhenNoWindows) {
        this.eofWhenNoWindows = eofWhenNoWindows;
    }

    public boolean isEOFWhenNoWindows() {
        return this.eofWhenNoWindows;
    }

    @Override
    public synchronized Interactable getFocusedInteractable() {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.getFocusedInteractable();
        }
        return this.backgroundPane.getFocusedInteractable();
    }

    @Override
    public synchronized boolean handleInput(KeyStroke keyStroke) {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.handleInput(keyStroke);
        }
        return this.backgroundPane.handleInput(keyStroke);
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public synchronized WindowBasedTextGUI addWindow(Window window) {
        if (window.getComponent() == null) {
            window.setComponent(new EmptySpace(TerminalSize.ONE));
        }
        if (window.getTextGUI() != null) {
            window.getTextGUI().removeWindow(window);
        }
        window.setTextGUI(this);
        this.windowManager.onAdded(this, window, this.windows);
        if (!this.windows.contains(window)) {
            this.windows.add(window);
        }
        if (!window.getHints().contains(Window.Hint.NO_FOCUS)) {
            this.setActiveWindow(window);
        }
        this.hadWindowAtSomePoint = true;
        this.invalidate();
        return this;
    }

    @Override
    public WindowBasedTextGUI addWindowAndWait(Window window) {
        this.addWindow(window);
        window.waitUntilClosed();
        return this;
    }

    @Override
    public synchronized WindowBasedTextGUI removeWindow(Window window) {
        block3: {
            if (!this.windows.remove(window)) {
                return this;
            }
            window.setTextGUI(null);
            this.windowManager.onRemoved(this, window, this.windows);
            if (this.activeWindow == window) {
                for (int index = this.windows.size() - 1; index >= 0; --index) {
                    Window candidate = this.windows.get(index);
                    if (candidate.getHints().contains(Window.Hint.NO_FOCUS)) continue;
                    this.setActiveWindow(candidate);
                    break block3;
                }
                this.setActiveWindow(null);
            }
        }
        this.invalidate();
        return this;
    }

    @Override
    public void waitForWindowToClose(Window window) {
        while (window.getTextGUI() != null) {
            boolean sleep = true;
            TextGUIThread guiThread = this.getGUIThread();
            if (Thread.currentThread() == guiThread.getThread()) {
                try {
                    sleep = !guiThread.processEventsAndUpdate();
                }
                catch (EOFException ignore) {
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException while waiting for window to close", e);
                }
            }
            if (!sleep) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ignore) {}
        }
    }

    @Override
    public synchronized Collection<Window> getWindows() {
        return Collections.unmodifiableList(new ArrayList<Window>(this.windows));
    }

    @Override
    public synchronized MultiWindowTextGUI setActiveWindow(Window activeWindow) {
        this.activeWindow = activeWindow;
        if (activeWindow != null) {
            this.moveToTop(activeWindow);
        }
        return this;
    }

    @Override
    public synchronized Window getActiveWindow() {
        return this.activeWindow;
    }

    @Override
    public BasePane getBackgroundPane() {
        return this.backgroundPane;
    }

    @Override
    public Screen getScreen() {
        return this.virtualScreen;
    }

    @Override
    public WindowPostRenderer getWindowPostRenderer() {
        return this.postRenderer;
    }

    @Override
    public synchronized WindowBasedTextGUI moveToTop(Window window) {
        if (!this.windows.contains(window)) {
            throw new IllegalArgumentException("Window " + window + " isn't in MultiWindowTextGUI " + this);
        }
        this.windows.remove(window);
        this.windows.add(window);
        this.invalidate();
        return this;
    }

    @Override
    public synchronized WindowBasedTextGUI cycleActiveWindow(boolean reverse) {
        if (this.windows.isEmpty() || this.windows.size() == 1 || this.activeWindow != null && this.activeWindow.getHints().contains(Window.Hint.MODAL)) {
            return this;
        }
        Window originalActiveWindow = this.activeWindow;
        Window nextWindow = this.activeWindow == null ? (reverse ? this.windows.get(this.windows.size() - 1) : this.windows.get(0)) : this.getNextWindow(reverse, this.activeWindow);
        int noFocusWindows = 0;
        while (nextWindow.getHints().contains(Window.Hint.NO_FOCUS)) {
            if (++noFocusWindows == this.windows.size()) {
                return this;
            }
            if ((nextWindow = this.getNextWindow(reverse, nextWindow)) != originalActiveWindow) continue;
            return this;
        }
        if (reverse) {
            this.moveToTop(nextWindow);
        } else if (originalActiveWindow != null) {
            this.windows.remove(originalActiveWindow);
            this.windows.add(0, originalActiveWindow);
        }
        this.setActiveWindow(nextWindow);
        return this;
    }

    private Window getNextWindow(boolean reverse, Window window) {
        int index = this.windows.indexOf(window);
        if (reverse) {
            if (++index >= this.windows.size()) {
                index = 0;
            }
        } else if (--index < 0) {
            index = this.windows.size() - 1;
        }
        return this.windows.get(index);
    }
}

