/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import com.googlecode.lanterna.gui2.dialogs.TextInputDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.TextInputDialogResultValidator;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class TextInputDialog
extends DialogWindow {
    private final TextBox textBox;
    private final TextInputDialogResultValidator validator;
    private String result = null;

    TextInputDialog(String title, String description, TerminalSize textBoxPreferredSize, String initialContent, TextInputDialogResultValidator validator, boolean password) {
        super(title);
        this.textBox = new TextBox(textBoxPreferredSize, initialContent);
        this.validator = validator;
        if (password) {
            this.textBox.setMask(Character.valueOf('*'));
        }
        Panel buttonPanel = new Panel();
        buttonPanel.setLayoutManager(new GridLayout(2).setHorizontalSpacing(1));
        buttonPanel.addComponent((Component)new Button(LocalizedString.OK.toString(), new Runnable(){

            @Override
            public void run() {
                TextInputDialog.this.onOK();
            }
        }).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.CENTER, GridLayout.Alignment.CENTER, true, false)));
        buttonPanel.addComponent(new Button(LocalizedString.Cancel.toString(), new Runnable(){

            @Override
            public void run() {
                TextInputDialog.this.onCancel();
            }
        }));
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager(new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        if (description != null) {
            mainPanel.addComponent(new Label(description));
        }
        mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        ((TextBox)this.textBox.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false))).addTo(mainPanel);
        mainPanel.addComponent(new EmptySpace(TerminalSize.ONE));
        ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false))).addTo(mainPanel);
        this.setComponent(mainPanel);
    }

    private void onOK() {
        String errorMessage;
        String text = this.textBox.getText();
        if (this.validator != null && (errorMessage = this.validator.validate(text)) != null) {
            MessageDialog.showMessageDialog(this.getTextGUI(), this.getTitle(), errorMessage, MessageDialogButton.OK);
            return;
        }
        this.result = text;
        this.close();
    }

    private void onCancel() {
        this.close();
    }

    @Override
    public String showDialog(WindowBasedTextGUI textGUI) {
        this.result = null;
        super.showDialog(textGUI);
        return this.result;
    }

    public static String showDialog(WindowBasedTextGUI textGUI, String title, String description, String initialContent) {
        TextInputDialog textInputDialog = (TextInputDialog)((TextInputDialogBuilder)((TextInputDialogBuilder)new TextInputDialogBuilder().setTitle(title)).setDescription(description)).setInitialContent(initialContent).build();
        return textInputDialog.showDialog(textGUI);
    }

    public static BigInteger showNumberDialog(WindowBasedTextGUI textGUI, String title, String description, String initialContent) {
        TextInputDialog textInputDialog = (TextInputDialog)((TextInputDialogBuilder)((TextInputDialogBuilder)new TextInputDialogBuilder().setTitle(title)).setDescription(description)).setInitialContent(initialContent).setValidationPattern(Pattern.compile("[0-9]+"), "Not a number").build();
        String numberString = textInputDialog.showDialog(textGUI);
        return numberString != null ? new BigInteger(numberString) : null;
    }

    public static String showPasswordDialog(WindowBasedTextGUI textGUI, String title, String description, String initialContent) {
        TextInputDialog textInputDialog = (TextInputDialog)((TextInputDialogBuilder)((TextInputDialogBuilder)new TextInputDialogBuilder().setTitle(title)).setDescription(description)).setInitialContent(initialContent).setPasswordInput(true).build();
        return textInputDialog.showDialog(textGUI);
    }
}

