/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.dialogs.AbstractDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.TextInputDialog;
import com.googlecode.lanterna.gui2.dialogs.TextInputDialogResultValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextInputDialogBuilder
extends AbstractDialogBuilder<TextInputDialogBuilder, TextInputDialog> {
    private String initialContent = "";
    private TerminalSize textBoxSize = null;
    private TextInputDialogResultValidator validator = null;
    private boolean passwordInput = false;

    public TextInputDialogBuilder() {
        super("TextInputDialog");
    }

    @Override
    protected TextInputDialogBuilder self() {
        return this;
    }

    @Override
    protected TextInputDialog buildDialog() {
        TerminalSize size = this.textBoxSize;
        if ((this.initialContent == null || this.initialContent.trim().equals("")) && size == null) {
            size = new TerminalSize(40, 1);
        }
        return new TextInputDialog(this.title, this.description, size, this.initialContent, this.validator, this.passwordInput);
    }

    public TextInputDialogBuilder setInitialContent(String initialContent) {
        this.initialContent = initialContent;
        return this;
    }

    public String getInitialContent() {
        return this.initialContent;
    }

    public TextInputDialogBuilder setTextBoxSize(TerminalSize textBoxSize) {
        this.textBoxSize = textBoxSize;
        return this;
    }

    public TerminalSize getTextBoxSize() {
        return this.textBoxSize;
    }

    public TextInputDialogBuilder setValidator(TextInputDialogResultValidator validator) {
        this.validator = validator;
        return this;
    }

    public TextInputDialogResultValidator getValidator() {
        return this.validator;
    }

    public TextInputDialogBuilder setValidationPattern(final Pattern pattern, final String errorMessage) {
        return this.setValidator(new TextInputDialogResultValidator(){

            @Override
            public String validate(String content) {
                Matcher matcher = pattern.matcher(content);
                if (!matcher.matches()) {
                    if (errorMessage == null) {
                        return "Invalid input";
                    }
                    return errorMessage;
                }
                return null;
            }
        });
    }

    public TextInputDialogBuilder setPasswordInput(boolean passwordInput) {
        this.passwordInput = passwordInput;
        return this;
    }

    public boolean isPasswordInput() {
        return this.passwordInput;
    }
}

