/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;
import java.util.List;

public class MouseCharacterPattern
implements CharacterPattern {
    private static final char[] PATTERN = new char[]{'\u001b', '[', 'M'};

    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        int size = seq.size();
        if (size > 6) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            if (i >= size) {
                return CharacterPattern.Matching.NOT_YET;
            }
            if (seq.get(i).charValue() == PATTERN[i]) continue;
            return null;
        }
        if (size < 6) {
            return CharacterPattern.Matching.NOT_YET;
        }
        MouseActionType actionType = null;
        int button = (seq.get(3).charValue() & 3) + 1;
        if (button == 4) {
            button = 0;
        }
        int actionCode = (seq.get(3).charValue() & 0x60) >> 5;
        switch (actionCode) {
            case 1: {
                if (button > 0) {
                    actionType = MouseActionType.CLICK_DOWN;
                    break;
                }
                actionType = MouseActionType.CLICK_RELEASE;
                break;
            }
            case 0: 
            case 2: {
                if (button == 0) {
                    actionType = MouseActionType.MOVE;
                    break;
                }
                actionType = MouseActionType.DRAG;
                break;
            }
            case 3: {
                if (button == 1) {
                    actionType = MouseActionType.SCROLL_UP;
                    button = 4;
                    break;
                }
                actionType = MouseActionType.SCROLL_DOWN;
                button = 5;
            }
        }
        TerminalPosition pos = new TerminalPosition(seq.get(4).charValue() - 33, seq.get(5).charValue() - 33);
        MouseAction ma = new MouseAction(actionType, button, pos);
        return new CharacterPattern.Matching(ma);
    }
}

