/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;

public class NormalCharacterPattern
implements CharacterPattern {
    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        if (seq.size() != 1) {
            return null;
        }
        char ch = seq.get(0).charValue();
        if (NormalCharacterPattern.isPrintableChar(ch)) {
            KeyStroke ks = new KeyStroke(Character.valueOf(ch), false, false);
            return new CharacterPattern.Matching(ks);
        }
        return null;
    }

    private static boolean isPrintableChar(char c) {
        if (Character.isISOControl(c)) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

