/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorPalette;
import java.awt.Color;

public class TerminalEmulatorColorConfiguration {
    private final TerminalEmulatorPalette colorPalette;
    private final boolean useBrightColorsOnBold;

    public static TerminalEmulatorColorConfiguration getDefault() {
        return TerminalEmulatorColorConfiguration.newInstance(TerminalEmulatorPalette.STANDARD_VGA);
    }

    public static TerminalEmulatorColorConfiguration newInstance(TerminalEmulatorPalette colorPalette) {
        return new TerminalEmulatorColorConfiguration(colorPalette, true);
    }

    private TerminalEmulatorColorConfiguration(TerminalEmulatorPalette colorPalette, boolean useBrightColorsOnBold) {
        this.colorPalette = colorPalette;
        this.useBrightColorsOnBold = useBrightColorsOnBold;
    }

    public Color toAWTColor(TextColor color, boolean isForeground, boolean inBoldContext) {
        if (color instanceof TextColor.ANSI) {
            return this.colorPalette.get((TextColor.ANSI)color, isForeground, inBoldContext && this.useBrightColorsOnBold);
        }
        return color.toColor();
    }
}

