/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;

public class GcBiasUtils {
    public static int calculateGc(byte[] bases, int startIndex, int endIndex, CalculateGcState state) {
        if (state.init) {
            state.init = false;
            state.gcCount = 0;
            state.nCount = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                byte base = bases[i];
                if (SequenceUtil.basesEqual((byte)base, (byte)71) || SequenceUtil.basesEqual((byte)base, (byte)67)) {
                    ++state.gcCount;
                    continue;
                }
                if (!SequenceUtil.basesEqual((byte)base, (byte)78)) continue;
                ++state.nCount;
            }
        } else {
            byte newBase = bases[endIndex - 1];
            if (SequenceUtil.basesEqual((byte)newBase, (byte)71) || SequenceUtil.basesEqual((byte)newBase, (byte)67)) {
                ++state.gcCount;
            } else if (newBase == 78) {
                ++state.nCount;
            }
            if (SequenceUtil.basesEqual((byte)state.priorBase, (byte)71) || SequenceUtil.basesEqual((byte)state.priorBase, (byte)67)) {
                --state.gcCount;
            } else if (SequenceUtil.basesEqual((byte)state.priorBase, (byte)78)) {
                --state.nCount;
            }
        }
        state.priorBase = bases[startIndex];
        if (state.nCount > 4) {
            return -1;
        }
        return state.gcCount * 100 / (endIndex - startIndex);
    }

    public static int[] calculateRefWindowsByGc(int windows, File referenceSequence, int windowSize) {
        ReferenceSequence ref;
        ReferenceSequenceFile refFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)referenceSequence);
        int[] windowsByGc = new int[windows];
        while ((ref = refFile.nextSequence()) != null) {
            byte[] refBases = ref.getBases();
            StringUtil.toUpperCase((byte[])refBases);
            int refLength = refBases.length;
            int lastWindowStart = refLength - windowSize;
            CalculateGcState state = new GcBiasUtils().new CalculateGcState();
            for (int i = 1; i < lastWindowStart; ++i) {
                int windowEnd = i + windowSize;
                int gcBin = GcBiasUtils.calculateGc(refBases, i, windowEnd, state);
                if (gcBin == -1) continue;
                int n = gcBin;
                windowsByGc[n] = windowsByGc[n] + 1;
            }
        }
        return windowsByGc;
    }

    public static byte[] calculateAllGcs(byte[] refBases, int lastWindowStart, int windowSize) {
        CalculateGcState state = new GcBiasUtils().new CalculateGcState();
        int refLength = refBases.length;
        byte[] gc = new byte[refLength + 1];
        for (int i = 1; i < lastWindowStart; ++i) {
            int windowEnd = i + windowSize;
            int windowGc = GcBiasUtils.calculateGc(refBases, i, windowEnd, state);
            gc[i] = (byte)windowGc;
        }
        return gc;
    }

    class CalculateGcState {
        boolean init = true;
        int nCount;
        int gcCount;
        byte priorBase;

        CalculateGcState() {
        }
    }
}

