/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import picard.analysis.CpgLocation;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.RrbsCpgDetailMetrics;
import picard.analysis.RrbsMetrics;
import picard.analysis.RrbsSummaryMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordAndReference;
import picard.metrics.SAMRecordAndReferenceMultiLevelCollector;

public class RrbsMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<RrbsMetrics, Comparable<?>> {
    private final int minReadLength;
    private final double maxMismatchRate;
    private final int cQualityThreshold;
    private final int nextBaseQualityThreshold;

    public RrbsMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, int cQualityThreshold, int nextBaseQualityThreshold, int minReadLength, double maxMismatchRate) {
        this.cQualityThreshold = cQualityThreshold;
        this.nextBaseQualityThreshold = nextBaseQualityThreshold;
        this.minReadLength = minReadLength;
        this.maxMismatchRate = maxMismatchRate;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<RrbsMetrics, Comparable<?>, SAMRecordAndReference> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitRrbsMetricsCollector(sample, library, readGroup);
    }

    private byte[] getFragment(byte[] fullArray, int fragmentStart, int length) {
        return Arrays.copyOfRange(fullArray, fragmentStart, fragmentStart + length);
    }

    private boolean isC(byte refBase, byte readBase) {
        return SequenceUtil.basesEqual((byte)refBase, (byte)67) && SequenceUtil.bisulfiteBasesEqual((byte)readBase, (byte)refBase);
    }

    private boolean isValidCpg(byte[] refBases, byte[] readBases, byte[] readQualities, int index) {
        return this.isC(refBases[index], readBases[index]) && SequenceUtil.basesEqual((byte)refBases[index + 1], (byte)readBases[index + 1]) && this.isAboveCytoQcThreshold(readQualities, index);
    }

    private boolean isAboveCytoQcThreshold(byte[] readQualities, int index) {
        return index < readQualities.length - 1 && readQualities[index] >= this.cQualityThreshold && readQualities[index + 1] >= this.nextBaseQualityThreshold;
    }

    private int getCurRefIndex(int refStart, int blockLength, int idx, boolean isNegative) {
        return isNegative ? refStart + (blockLength - 1) - idx - 1 : refStart + idx;
    }

    private class PerUnitRrbsMetricsCollector
    implements PerUnitMetricCollector<RrbsMetrics, Comparable<?>, SAMRecordAndReference> {
        final String sample;
        final String library;
        final String readGroup;
        int nCytoConverted = 0;
        int nCytoTotal = 0;
        final Histogram<CpgLocation> cpgTotal = new Histogram();
        final Histogram<CpgLocation> cpgConverted = new Histogram();
        int mappedRecordCount = 0;
        int smallReadCount = 0;
        int mismatchCount = 0;
        int noCpgCount = 0;
        double cytoConversionRate;
        double cpgConversionRate;
        int nCpgSeen;
        int nCpgConverted;
        double coverageMean;
        int coverageMedian;

        public PerUnitRrbsMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
        }

        @Override
        public void acceptRecord(SAMRecordAndReference args) {
            ++this.mappedRecordCount;
            SAMRecord samRecord = args.getSamRecord();
            ReferenceSequence referenceSequence = args.getReferenceSequence();
            byte[] readBases = samRecord.getReadBases();
            byte[] readQualities = samRecord.getBaseQualities();
            byte[] refBases = referenceSequence.getBases();
            if (samRecord.getReadLength() < RrbsMetricsCollector.this.minReadLength) {
                ++this.smallReadCount;
                return;
            }
            if ((long)SequenceUtil.countMismatches((SAMRecord)samRecord, (byte[])refBases, (boolean)true) > Math.round((double)samRecord.getReadLength() * RrbsMetricsCollector.this.maxMismatchRate)) {
                ++this.mismatchCount;
                return;
            }
            int recordCpgs = 0;
            for (AlignmentBlock alignmentBlock : samRecord.getAlignmentBlocks()) {
                int blockLength = alignmentBlock.getLength();
                int refFragmentStart = alignmentBlock.getReferenceStart() - 1;
                int readFragmentStart = alignmentBlock.getReadStart() - 1;
                byte[] refFragment = RrbsMetricsCollector.this.getFragment(refBases, refFragmentStart, blockLength);
                byte[] readFragment = RrbsMetricsCollector.this.getFragment(readBases, readFragmentStart, blockLength);
                byte[] readQualityFragment = RrbsMetricsCollector.this.getFragment(readQualities, readFragmentStart, blockLength);
                if (samRecord.getReadNegativeStrandFlag()) {
                    SequenceUtil.reverseComplement((byte[])refFragment);
                    SequenceUtil.reverseComplement((byte[])readFragment);
                    SequenceUtil.reverseQualities((byte[])readQualityFragment);
                }
                for (int i = 0; i < blockLength - 1; ++i) {
                    int curRefIndex = RrbsMetricsCollector.this.getCurRefIndex(refFragmentStart, blockLength, i, samRecord.getReadNegativeStrandFlag());
                    if (SequenceUtil.basesEqual((byte)refFragment[i], (byte)67) && SequenceUtil.basesEqual((byte)refFragment[i + 1], (byte)71)) {
                        if (RrbsMetricsCollector.this.isValidCpg(refFragment, readFragment, readQualityFragment, i)) {
                            ++recordCpgs;
                            CpgLocation curLocation = new CpgLocation(samRecord.getReferenceName(), curRefIndex);
                            this.cpgTotal.increment((Comparable)curLocation);
                            if (SequenceUtil.isBisulfiteConverted((byte)readFragment[i], (byte)refFragment[i])) {
                                this.cpgConverted.increment((Comparable)curLocation);
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (!RrbsMetricsCollector.this.isC(refFragment[i], readFragment[i]) || !RrbsMetricsCollector.this.isAboveCytoQcThreshold(readQualities, i) || !SequenceUtil.bisulfiteBasesEqual((boolean)false, (byte)readFragment[i + 1], (byte)refFragment[i + 1])) continue;
                    ++this.nCytoTotal;
                    if (!SequenceUtil.isBisulfiteConverted((byte)readFragment[i], (byte)refFragment[i])) continue;
                    ++this.nCytoConverted;
                }
            }
            if (recordCpgs == 0) {
                ++this.noCpgCount;
            }
        }

        @Override
        public void finish() {
            this.cytoConversionRate = this.nCytoTotal == 0 ? 0.0 : (double)this.nCytoConverted / (double)this.nCytoTotal;
            this.nCpgSeen = (int)this.cpgTotal.getSumOfValues();
            this.nCpgConverted = (int)this.cpgConverted.getSumOfValues();
            this.cpgConversionRate = this.nCpgSeen == 0 ? 0.0 : (double)this.nCpgConverted / (double)this.nCpgSeen;
            this.coverageMean = this.cpgTotal.getMeanBinSize();
            this.coverageMedian = (int)this.cpgTotal.getMedianBinSize();
        }

        @Override
        public void addMetricsToFile(MetricsFile<RrbsMetrics, Comparable<?>> metricsFile) {
            RrbsSummaryMetrics summaryMetrics = this.buildSummaryMetrics();
            List<RrbsCpgDetailMetrics> detailMetrics = this.buildDetailMetrics();
            RrbsMetrics rrbsMetrics = new RrbsMetrics(summaryMetrics, detailMetrics);
            metricsFile.addMetric((MetricBase)rrbsMetrics);
        }

        private RrbsSummaryMetrics buildSummaryMetrics() {
            RrbsSummaryMetrics summaryMetrics = new RrbsSummaryMetrics();
            summaryMetrics.SAMPLE = this.sample;
            summaryMetrics.READ_GROUP = this.readGroup;
            summaryMetrics.LIBRARY = this.library;
            summaryMetrics.READS_ALIGNED = this.mappedRecordCount;
            summaryMetrics.NON_CPG_BASES = this.nCytoTotal;
            summaryMetrics.NON_CPG_CONVERTED_BASES = this.nCytoConverted;
            summaryMetrics.PCT_NON_CPG_BASES_CONVERTED = this.cytoConversionRate;
            summaryMetrics.CPG_BASES_SEEN = this.nCpgSeen;
            summaryMetrics.CPG_BASES_CONVERTED = this.nCpgConverted;
            summaryMetrics.PCT_CPG_BASES_CONVERTED = this.cpgConversionRate;
            summaryMetrics.MEAN_CPG_COVERAGE = this.coverageMean;
            summaryMetrics.MEDIAN_CPG_COVERAGE = this.coverageMedian;
            summaryMetrics.READS_IGNORED_SHORT = this.smallReadCount;
            summaryMetrics.READS_WITH_NO_CPG = this.noCpgCount;
            summaryMetrics.READS_IGNORED_MISMATCHES = this.mismatchCount;
            return summaryMetrics;
        }

        private List<RrbsCpgDetailMetrics> buildDetailMetrics() {
            ArrayList<RrbsCpgDetailMetrics> detailMetrics = new ArrayList<RrbsCpgDetailMetrics>();
            for (CpgLocation key : this.cpgTotal.keySet()) {
                RrbsCpgDetailMetrics cpgMetric = new RrbsCpgDetailMetrics();
                cpgMetric.SAMPLE = this.sample;
                cpgMetric.READ_GROUP = this.readGroup;
                cpgMetric.LIBRARY = this.library;
                cpgMetric.SEQUENCE_NAME = key.getSequence();
                cpgMetric.POSITION = key.getPosition();
                cpgMetric.TOTAL_SITES = (int)this.cpgTotal.get((Comparable)key).getValue();
                cpgMetric.CONVERTED_SITES = this.cpgConverted.containsKey((Comparable)key) ? (int)this.cpgConverted.get((Comparable)key).getValue() : 0;
                cpgMetric.PCT_CONVERTED = cpgMetric.CONVERTED_SITES == 0 ? 0.0 : (double)cpgMetric.CONVERTED_SITES.intValue() / (double)cpgMetric.TOTAL_SITES.intValue();
                detailMetrics.add(cpgMetric);
            }
            return detailMetrics;
        }
    }
}

