/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import picard.PicardException;
import picard.util.MathUtil;

public class TheoreticalSensitivity {
    private static final Log log = Log.getInstance(TheoreticalSensitivity.class);
    private static final int SAMPLING_MAX = 600;
    private static final int MAX_CONSIDERED_DEPTH = 1000;

    public static double hetSNPSensitivity(double[] depthDistribution, double[] qualityDistribution, int sampleSize, double logOddsThreshold) {
        return TheoreticalSensitivity.hetSNPSensitivity(depthDistribution, qualityDistribution, sampleSize, logOddsThreshold, true);
    }

    public static double hetSNPSensitivity(double[] depthDistribution, double[] qualityDistribution, int sampleSize, double logOddsThreshold, boolean withLogging) {
        int N = Math.min(depthDistribution.length, 1001);
        if (withLogging) {
            log.info(new Object[]{"Creating Roulette Wheel"});
        }
        RouletteWheel qualitySampler = new RouletteWheel(qualityDistribution);
        if (withLogging) {
            log.info(new Object[]{"Calculating quality sums from quality sampler"});
        }
        List<ArrayList<Integer>> qualitySums = qualitySampler.sampleCumulativeSums(N, sampleSize, withLogging);
        ArrayList<Double> qualitySumThresholds = new ArrayList<Double>(N);
        double LOG_10 = Math.log10(2.0);
        for (int n = 0; n < N; ++n) {
            qualitySumThresholds.add(10.0 * ((double)n * LOG_10 + logOddsThreshold));
        }
        if (withLogging) {
            log.info(new Object[]{"Calculating theoretical het sensitivity"});
        }
        List<ArrayList<Double>> probabilityToExceedThreshold = TheoreticalSensitivity.proportionsAboveThresholds(qualitySums, qualitySumThresholds);
        List<ArrayList<Double>> altDepthDistribution = TheoreticalSensitivity.hetAltDepthDistribution(N);
        double result = 0.0;
        for (int n = 0; n < N; ++n) {
            for (int m = 0; m <= n; ++m) {
                result += depthDistribution[n] * altDepthDistribution.get(n).get(m) * probabilityToExceedThreshold.get(m).get(n);
            }
        }
        return result;
    }

    public static List<ArrayList<Double>> proportionsAboveThresholds(List<ArrayList<Integer>> lists, List<Double> thresholds) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        for (ArrayList<Integer> list : lists) {
            ArrayList<Double> newRow = new ArrayList<Double>(Collections.nCopies(thresholds.size(), 0.0));
            Collections.sort(list);
            int n = 0;
            int j = 0;
            while (n < thresholds.size() && j < list.size()) {
                if (thresholds.get(n) > (double)list.get(j).intValue()) {
                    ++j;
                    continue;
                }
                newRow.set(n++, (double)(list.size() - j) / (double)list.size());
            }
            result.add(newRow);
        }
        return result;
    }

    public static List<ArrayList<Double>> hetAltDepthDistribution(int N) {
        ArrayList<ArrayList<Double>> table = new ArrayList<ArrayList<Double>>();
        for (int n = 0; n < N; ++n) {
            ArrayList<Double> nthRow = new ArrayList<Double>();
            nthRow.add(Math.pow(0.5, n));
            for (int m = 1; m < n; ++m) {
                nthRow.add((double)n * 0.5 / (double)m * (Double)((ArrayList)table.get(n - 1)).get(m - 1));
            }
            if (n > 0) {
                nthRow.add((Double)nthRow.get(0));
            }
            table.add(nthRow);
        }
        return table;
    }

    public static double[] normalizeHistogram(Histogram<Integer> histogram) {
        if (histogram == null) {
            throw new PicardException("Histogram is null and cannot be normalized");
        }
        double histogramSumOfValues = histogram.getSumOfValues();
        double[] normalizedHistogram = new double[histogram.size()];
        for (int i = 0; i < histogram.size(); ++i) {
            if (histogram.get((Comparable)Integer.valueOf(i)) == null) continue;
            normalizedHistogram[i] = histogram.get((Comparable)Integer.valueOf(i)).getValue() / histogramSumOfValues;
        }
        return normalizedHistogram;
    }

    public static class RouletteWheel {
        private final List<Double> probabilities;
        private final int N;
        private int count = 0;
        private Random rng = new Random(51L);

        RouletteWheel(double[] weights) {
            this.N = weights.length;
            this.probabilities = new ArrayList<Double>();
            double wMax = MathUtil.max(weights);
            if (wMax == 0.0) {
                throw new PicardException("Quality score distribution is empty.");
            }
            for (double w : weights) {
                this.probabilities.add(w / wMax);
            }
        }

        public int draw() {
            do {
                int n = (int)((double)this.N * this.rng.nextDouble());
                ++this.count;
                if (!(this.rng.nextDouble() < this.probabilities.get(n))) continue;
                this.count = 0;
                return n;
            } while (this.count < 600);
            this.count = 0;
            return 0;
        }

        public List<ArrayList<Integer>> sampleCumulativeSums(int maxNumberOfSummands, int sampleSize, boolean withLogging) {
            ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
            for (int m = 0; m < maxNumberOfSummands; ++m) {
                result.add(new ArrayList());
            }
            for (int iteration = 0; iteration < sampleSize; ++iteration) {
                int cumulativeSum = 0;
                for (int m = 0; m < maxNumberOfSummands; ++m) {
                    ((ArrayList)result.get(m)).add(cumulativeSum);
                    cumulativeSum += this.draw();
                }
                if (!withLogging || iteration % 1000 != 0) continue;
                log.info(new Object[]{iteration + " sampling iterations completed"});
            }
            return result;
        }
    }
}

