/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.replicates;

import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.ComparableTuple;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.CompoundFilter;
import htsjdk.variant.variantcontext.filter.FilteringVariantContextIterator;
import htsjdk.variant.variantcontext.filter.GenotypeQualityFilter;
import htsjdk.variant.variantcontext.filter.HeterozygosityFilter;
import htsjdk.variant.variantcontext.filter.PassingVariantFilter;
import htsjdk.variant.variantcontext.filter.SnpFilter;
import htsjdk.variant.variantcontext.filter.VariantContextFilter;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.analysis.replicates.IndependentReplicateMetric;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.Alpha;
import picard.filter.CountingPairedFilter;

@CommandLineProgramProperties(summary="Estimates the rate of independent replication rate of reads within a bam. \nThat is, it estimates the fraction of the reads which would be marked as duplicates but are actually biological replicates, independent observations of the data. ", oneLineSummary="Estimates the rate of independent replication of reads within a bam.", programGroup=Alpha.class)
public class CollectIndependentReplicateMetrics
extends CommandLineProgram {
    private static final int DOUBLETON_SIZE = 2;
    private static final int TRIPLETON_SIZE = 3;
    @Argument(shortName="I", doc="Input (indexed) BAM file.")
    public File INPUT;
    @Argument(shortName="O", doc="Write metrics to this file")
    public File OUTPUT;
    @Argument(shortName="MO", doc="Write the confusion matrix (of UMIs) to this file", optional=true)
    public File MATRIX_OUTPUT;
    @Argument(shortName="V", doc="Input VCF file")
    public File VCF;
    @Argument(shortName="GQ", doc="minimal value for the GQ field in the VCF to use variant site.", optional=true)
    public Integer MINIMUM_GQ = 90;
    @Argument(shortName="MQ", doc="minimal value for the mapping quality of the reads to be used in the estimation.", optional=true)
    public Integer MINIMUM_MQ = 40;
    @Argument(shortName="BQ", doc="minimal value for the base quality of a base to be used in the estimation.", optional=true)
    public Integer MINIMUM_BQ = 17;
    @Argument(shortName="ALIAS", doc="Name of sample to look at in VCF. Can be omitted if VCF contains only one sample.", optional=true)
    public String SAMPLE = null;
    @Argument(doc="Number of sets to examine before stopping.", optional=true)
    public Integer STOP_AFTER = 0;
    @Argument(doc="Barcode SAM tag.", optional=true)
    public String BARCODE_TAG = "RX";
    @Argument(doc="Barcode Quality SAM tag.", optional=true)
    public String BARCODE_BQ = "QX";
    @Argument(shortName="MBQ", doc="minimal value for the base quality of all the bases in a molecular barcode, for it to be used.", optional=true)
    public Integer MINIMUM_BARCODE_BQ = 30;
    private static final Log log = Log.getInstance(CollectIndependentReplicateMetrics.class);

    @Override
    protected int doWork() {
        Object setRep;
        Object set;
        IOUtil.assertFileIsReadable((File)this.VCF);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.MATRIX_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.MATRIX_OUTPUT);
        }
        VCFFileReader vcf = new VCFFileReader(this.VCF, false);
        VCFHeader vcfFileHeader = vcf.getFileHeader();
        ArrayList samples = vcfFileHeader.getSampleNamesInOrder();
        if (this.SAMPLE == null) {
            if (samples.size() != 1) {
                throw new IllegalArgumentException("When sample is null, VCF must have exactly 1 sample. found " + samples.size());
            }
            this.SAMPLE = (String)samples.get(0);
            log.info(new Object[]{"No SAMPLE given, using sample from VCF: ", this.SAMPLE});
        } else if (!samples.contains(this.SAMPLE)) {
            throw new IllegalArgumentException("When sample is not null, VCF must contain supplied sample. Cannot find sample " + this.SAMPLE + " in vcf.");
        }
        Histogram umiConfusionMatrix = new Histogram("ConfusionUMI", "Count");
        Histogram umiConfusionMatrixEditDistance = new Histogram("ConfusionUMI", "EditDistance");
        IndependentReplicateMetric metric = new IndependentReplicateMetric();
        Histogram umiEditDistanceInDiffBiDups = new Histogram("editDistance", "diffAllelesCount");
        Histogram umiEditDistanceInSameBiDups = new Histogram("editDistance", "sameAllelesCount");
        Histogram alleleBalanceCount = new Histogram("alleleBalance", "alleleBalanceCount");
        SortedMap<QueryInterval, List<Allele>> intervalAlleleMap = this.getQueryIntervalsMap(this.VCF);
        Iterator<QueryInterval> queryIntervalIterator = intervalAlleleMap.keySet().iterator();
        log.info(new Object[]{"Found " + intervalAlleleMap.size() + " heterozygous sites in VCF."});
        SamReader in = SamReaderFactory.makeDefault().open(this.INPUT);
        log.info(new Object[]{"Querying BAM for sites."});
        SAMRecordIterator samRecordIterator = in.query(intervalAlleleMap.keySet().toArray(new QueryInterval[intervalAlleleMap.size()]), false);
        List samFilters = CollectionUtil.makeList((Object[])new SamRecordFilter[]{new AlignedFilter(true), new CountingPairedFilter(), new SecondaryOrSupplementaryFilter(), new MappingQualityFilter(this.MINIMUM_MQ.intValue())});
        FilteringSamIterator filteredSamRecordIterator = new FilteringSamIterator((Iterator)samRecordIterator, (SamRecordFilter)new AggregateFilter(samFilters));
        log.info(new Object[]{"Queried BAM, getting duplicate sets."});
        DuplicateSetIterator duplicateSets = new DuplicateSetIterator((CloseableIterator)filteredSamRecordIterator, in.getFileHeader());
        QueryInterval queryInterval = null;
        log.info(new Object[]{"Starting iteration on reads"});
        ProgressLogger progress = new ProgressLogger(log, 10000000, "examined", "duplicate sets");
        IndependentReplicateMetric locusData = new IndependentReplicateMetric();
        boolean useLocus = true;
        boolean newLocus = false;
        int thirdAlleleInfos = 0;
        Allele badAllele = null;
        String offendingReadName = null;
        block6: while (duplicateSets.hasNext()) {
            Object allele;
            Integer n;
            Integer n2;
            Object object;
            set = duplicateSets.next();
            setRep = set.getRepresentative();
            QueryInterval setRepsInterval = CollectIndependentReplicateMetrics.queryIntervalFromSamRecord(setRep);
            progress.record(setRep);
            if (!useLocus || queryInterval != null && CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, setRepsInterval)) {
                if (!useLocus) {
                    Integer n3 = metric.nThreeAllelesSites;
                    metric.nThreeAllelesSites = metric.nThreeAllelesSites + 1;
                    object = metric.nThreeAllelesSites;
                    if (++thirdAlleleInfos < 100) {
                        log.debug(new Object[]{"Skipping a locus due to third allele: " + badAllele + " but expected " + intervalAlleleMap.get(queryInterval) + " queryInterval " + queryInterval + " offending read name is : " + offendingReadName});
                    }
                }
                queryInterval = null;
            }
            while (queryIntervalIterator.hasNext() && (queryInterval == null || CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, setRepsInterval))) {
                if (locusData.nReferenceReads == 0 || locusData.nAlternateReads == 0) {
                    useLocus = false;
                    log.debug(new Object[]{"will not use this locus due to lack of evidence of het site."});
                }
                if (useLocus && newLocus) {
                    metric.merge(locusData);
                    log.debug(new Object[]{"merging metric. total nSites so far: " + metric.nSites});
                    byte alleleBalance = (byte)Math.round(100.0 * ((double)locusData.nAlternateReads.intValue() + 0.5) / (double)(locusData.nAlternateReads + locusData.nReferenceReads + 1));
                    alleleBalanceCount.increment((Comparable)Byte.valueOf(alleleBalance));
                    newLocus = false;
                }
                queryInterval = queryIntervalIterator.next();
                locusData = new IndependentReplicateMetric();
                locusData.nSites = 1;
                useLocus = true;
            }
            newLocus = true;
            if (queryInterval == null) break;
            int setSize = set.size();
            object = locusData;
            Integer.valueOf(object.nTotalReads + setSize);
            object.nTotalReads = object.nTotalReads;
            if (setSize > 1) {
                object = locusData;
                n2 = object.nDuplicateSets;
                n = object.nDuplicateSets = Integer.valueOf(object.nDuplicateSets + 1);
            }
            if (setSize == 2) {
                object = locusData;
                n2 = object.nExactlyDouble;
                n = object.nExactlyDouble = Integer.valueOf(object.nExactlyDouble + 1);
            } else if (setSize == 3) {
                object = locusData;
                n2 = object.nExactlyTriple;
                n = object.nExactlyTriple = Integer.valueOf(object.nExactlyTriple + 1);
            } else if (setSize > 3) {
                object = locusData;
                Integer.valueOf(object.nReadsInBigSets + setSize);
                object.nReadsInBigSets = object.nReadsInBigSets;
            }
            log.debug(new Object[]{"set size is: " + setSize});
            List allelesInVc = (List)intervalAlleleMap.get(queryInterval);
            log.debug(new Object[]{"alleles in VC: " + allelesInVc});
            int nRef = 0;
            int nAlt = 0;
            int nOther = 0;
            for (SAMRecord read2 : set.getRecords()) {
                int offset = read2.getReadPositionAtReferencePosition(queryInterval.start) - 1;
                if (offset == -1) {
                    log.debug(new Object[]{"got offset -1, getting new set"});
                    continue block6;
                }
                if (read2.getBaseQualities()[offset] <= this.MINIMUM_BQ) {
                    log.debug(new Object[]{"got low read quality, getting new set"});
                    continue block6;
                }
                allele = Allele.create((byte)read2.getReadBases()[offset]);
                if (((Allele)allelesInVc.get(0)).basesMatch(allele)) {
                    ++nRef;
                    continue;
                }
                if (((Allele)allelesInVc.get(1)).basesMatch(allele)) {
                    ++nAlt;
                    continue;
                }
                ++nOther;
                useLocus = false;
                badAllele = allele;
                offendingReadName = read2.getReadName();
            }
            Object object2 = locusData;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nAlternateReads + nAlt);
            ((IndependentReplicateMetric)((Object)object2)).nAlternateReads = ((IndependentReplicateMetric)((Object)object2)).nAlternateReads;
            object2 = locusData;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object2)).nReferenceReads + nRef);
            ((IndependentReplicateMetric)((Object)object2)).nReferenceReads = ((IndependentReplicateMetric)((Object)object2)).nReferenceReads;
            if (setSize == 1 || setSize > 3) continue;
            SetClassification classification = CollectIndependentReplicateMetrics.classifySet(nRef, nAlt, nOther);
            log.debug(new Object[]{"Classification of set is: " + (Object)((Object)classification)});
            if (setSize == 2) {
                Integer n4;
                Object object3;
                IndependentReplicateMetric independentReplicateMetric;
                Integer n5;
                IndependentReplicateMetric offset;
                boolean useBarcodes = !set.getRecords().stream().map(read -> read.getStringAttribute(this.BARCODE_BQ)).map(string -> string == null ? "" : string).map(string -> {
                    byte[] bytes = SAMUtils.fastqToPhred((String)string);
                    return IntStream.range(0, bytes.length).map(i -> bytes[i]).anyMatch(q -> q < this.MINIMUM_BARCODE_BQ);
                }).anyMatch(a -> a);
                log.debug(new Object[]{"using barcodes?" + useBarcodes});
                if (useBarcodes) {
                    offset = locusData;
                    allele = offset.nGoodBarcodes;
                    n5 = offset.nGoodBarcodes = Integer.valueOf(offset.nGoodBarcodes + 1);
                } else {
                    offset = locusData;
                    allele = offset.nBadBarcodes;
                    n5 = offset.nBadBarcodes = Integer.valueOf(offset.nBadBarcodes + 1);
                }
                List barcodes = set.getRecords().stream().map(read -> read.getStringAttribute(this.BARCODE_TAG)).map(string -> string == null ? "" : string).collect(Collectors.toList());
                log.debug(new Object[]{"found UMIs:" + barcodes});
                boolean hasMultipleOrientations = set.getRecords().stream().map(SAMRecord::getFirstOfPairFlag).distinct().count() != 1L;
                log.debug(new Object[]{"reads have multiple orientation?" + hasMultipleOrientations});
                byte editDistance = CollectIndependentReplicateMetrics.calculateEditDistance((String)barcodes.get(0), (String)barcodes.get(1));
                log.debug(new Object[]{"Edit distance between umi: " + editDistance});
                if (useBarcodes && editDistance != 0) {
                    if (hasMultipleOrientations) {
                        independentReplicateMetric = locusData;
                        object3 = independentReplicateMetric.nMismatchingUMIsInContraOrientedBiDups;
                        n4 = independentReplicateMetric.nMismatchingUMIsInContraOrientedBiDups = Integer.valueOf(independentReplicateMetric.nMismatchingUMIsInContraOrientedBiDups + 1);
                    } else {
                        independentReplicateMetric = locusData;
                        object3 = independentReplicateMetric.nMismatchingUMIsInCoOrientedBiDups;
                        n4 = independentReplicateMetric.nMismatchingUMIsInCoOrientedBiDups = Integer.valueOf(independentReplicateMetric.nMismatchingUMIsInCoOrientedBiDups + 1);
                    }
                }
                if (classification == SetClassification.DIFFERENT_ALLELES) {
                    independentReplicateMetric = locusData;
                    object3 = independentReplicateMetric.nDifferentAllelesBiDups;
                    n4 = independentReplicateMetric.nDifferentAllelesBiDups = Integer.valueOf(independentReplicateMetric.nDifferentAllelesBiDups + 1);
                    if (useBarcodes) {
                        umiEditDistanceInDiffBiDups.increment((Comparable)Byte.valueOf(editDistance));
                        if (editDistance == 0) {
                            independentReplicateMetric = locusData;
                            object3 = independentReplicateMetric.nMatchingUMIsInDiffBiDups;
                            n4 = independentReplicateMetric.nMatchingUMIsInDiffBiDups = Integer.valueOf(independentReplicateMetric.nMatchingUMIsInDiffBiDups + 1);
                        } else {
                            independentReplicateMetric = locusData;
                            object3 = independentReplicateMetric.nMismatchingUMIsInDiffBiDups;
                            n4 = independentReplicateMetric.nMismatchingUMIsInDiffBiDups = Integer.valueOf(independentReplicateMetric.nMismatchingUMIsInDiffBiDups + 1);
                        }
                    }
                } else if (classification == SetClassification.MISMATCHING_ALLELE) {
                    independentReplicateMetric = locusData;
                    object3 = independentReplicateMetric.nMismatchingAllelesBiDups;
                    n4 = independentReplicateMetric.nMismatchingAllelesBiDups = Integer.valueOf(independentReplicateMetric.nMismatchingAllelesBiDups + 1);
                } else {
                    if (classification == SetClassification.ALTERNATE_ALLELE) {
                        independentReplicateMetric = locusData;
                        object3 = independentReplicateMetric.nAlternateAllelesBiDups;
                        n4 = independentReplicateMetric.nAlternateAllelesBiDups = Integer.valueOf(independentReplicateMetric.nAlternateAllelesBiDups + 1);
                    } else {
                        independentReplicateMetric = locusData;
                        object3 = independentReplicateMetric.nReferenceAllelesBiDups;
                        n4 = independentReplicateMetric.nReferenceAllelesBiDups = Integer.valueOf(independentReplicateMetric.nReferenceAllelesBiDups + 1);
                    }
                    if (useBarcodes) {
                        Integer n6;
                        umiEditDistanceInSameBiDups.increment((Comparable)Byte.valueOf(editDistance));
                        ComparableTuple key = new ComparableTuple((Comparable)barcodes.get(0), (Comparable)barcodes.get(1));
                        umiConfusionMatrix.increment((Comparable)key);
                        if (!umiConfusionMatrixEditDistance.containsKey((Comparable)key)) {
                            umiConfusionMatrixEditDistance.increment((Comparable)key, (double)editDistance);
                        }
                        if (editDistance == 0) {
                            object3 = locusData;
                            n4 = ((IndependentReplicateMetric)((Object)object3)).nMatchingUMIsInSameBiDups;
                            n6 = ((IndependentReplicateMetric)((Object)object3)).nMatchingUMIsInSameBiDups = Integer.valueOf(((IndependentReplicateMetric)((Object)object3)).nMatchingUMIsInSameBiDups + 1);
                        } else {
                            object3 = locusData;
                            n4 = ((IndependentReplicateMetric)((Object)object3)).nMismatchingUMIsInSameBiDups;
                            n6 = ((IndependentReplicateMetric)((Object)object3)).nMismatchingUMIsInSameBiDups = Integer.valueOf(((IndependentReplicateMetric)((Object)object3)).nMismatchingUMIsInSameBiDups + 1);
                        }
                    }
                }
            }
            if (setSize == 3) {
                switch (classification) {
                    case MISMATCHING_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric = locusData;
                        Integer n7 = independentReplicateMetric.nMismatchingAllelesTriDups;
                        Integer n8 = independentReplicateMetric.nMismatchingAllelesTriDups = Integer.valueOf(independentReplicateMetric.nMismatchingAllelesTriDups + 1);
                        break;
                    }
                    case DIFFERENT_ALLELES: {
                        IndependentReplicateMetric independentReplicateMetric = locusData;
                        Integer n9 = independentReplicateMetric.nDifferentAllelesTriDups;
                        Integer n10 = independentReplicateMetric.nDifferentAllelesTriDups = Integer.valueOf(independentReplicateMetric.nDifferentAllelesTriDups + 1);
                        break;
                    }
                    case ALTERNATE_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric = locusData;
                        Integer n11 = independentReplicateMetric.nAlternateAllelesTriDups;
                        Integer n12 = independentReplicateMetric.nAlternateAllelesTriDups = Integer.valueOf(independentReplicateMetric.nAlternateAllelesTriDups + 1);
                        break;
                    }
                    case REFERENCE_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric = locusData;
                        Integer n13 = independentReplicateMetric.nReferenceAllelesTriDups;
                        Integer n14 = independentReplicateMetric.nReferenceAllelesTriDups = Integer.valueOf(independentReplicateMetric.nReferenceAllelesTriDups + 1);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Un possible!");
                    }
                }
            }
            if (this.STOP_AFTER <= 0 || progress.getCount() <= (long)this.STOP_AFTER.intValue()) continue;
            break;
        }
        if (useLocus && newLocus) {
            metric.merge(locusData);
            log.debug(new Object[]{"Merged final metric. nSites:" + metric.nSites});
        } else {
            set = metric.nThreeAllelesSites;
            metric.nThreeAllelesSites = metric.nThreeAllelesSites + 1;
            setRep = metric.nThreeAllelesSites;
            log.debug(new Object[]{"didn't merge last metric, due to 3rd allele: nThreeAllelesSites =" + metric.nThreeAllelesSites});
        }
        log.info(new Object[]{"Iteration done. Emitting metrics."});
        MetricsFile metricsFile = this.getMetricsFile();
        metric.calculateDerivedFields();
        metricsFile.addMetric((MetricBase)metric);
        metricsFile.addHistogram(alleleBalanceCount);
        metricsFile.addHistogram(umiEditDistanceInDiffBiDups);
        metricsFile.addHistogram(umiEditDistanceInSameBiDups);
        metricsFile.write(this.OUTPUT);
        MetricsFile confusionMetrics = this.getMetricsFile();
        if (this.MATRIX_OUTPUT != null) {
            confusionMetrics.addHistogram(umiConfusionMatrix);
            confusionMetrics.addHistogram(umiConfusionMatrixEditDistance);
            confusionMetrics.write(this.MATRIX_OUTPUT);
        }
        return 0;
    }

    private static boolean isCleanlyBefore(QueryInterval lhs, QueryInterval rhs) {
        return !lhs.overlaps(rhs) && lhs.compareTo(rhs) < 0;
    }

    private static SetClassification classifySet(int nRef, int nAlt, int nOther) {
        if (nOther != 0) {
            return SetClassification.MISMATCHING_ALLELE;
        }
        if (nAlt > 0 && nRef > 0) {
            return SetClassification.DIFFERENT_ALLELES;
        }
        if (nRef == 0) {
            return SetClassification.ALTERNATE_ALLELE;
        }
        if (nAlt == 0) {
            return SetClassification.REFERENCE_ALLELE;
        }
        throw new IllegalAccessError("shouldn't be here!");
    }

    private static QueryInterval queryIntervalFromSamRecord(SAMRecord samRecord) {
        return new QueryInterval(samRecord.getReferenceIndex().intValue(), samRecord.getStart(), samRecord.getEnd());
    }

    private static byte calculateEditDistance(String lhs, String rhs) {
        assert (lhs.length() == rhs.length());
        byte tmp = 0;
        for (int i = 0; i < rhs.length(); ++i) {
            if (rhs.charAt(i) == lhs.charAt(i)) continue;
            tmp = (byte)(tmp + 1);
        }
        return tmp;
    }

    private SortedMap<QueryInterval, List<Allele>> getQueryIntervalsMap(File vcf) {
        HashMap<String, Integer> contigIndexMap = new HashMap<String, Integer>();
        VCFFileReader vcfReader = new VCFFileReader(vcf, false);
        CompoundFilter compoundFilter = new CompoundFilter(true);
        compoundFilter.add((Object)new SnpFilter());
        compoundFilter.add((Object)new PassingVariantFilter());
        compoundFilter.add((Object)new GenotypeQualityFilter(this.MINIMUM_GQ.intValue(), this.SAMPLE));
        compoundFilter.add((Object)new HeterozygosityFilter(true, this.SAMPLE));
        FilteringVariantContextIterator hetIterator = new FilteringVariantContextIterator((Iterator)vcfReader.iterator(), (VariantContextFilter)compoundFilter);
        for (VCFContigHeaderLine vcfContig : vcfReader.getFileHeader().getContigLines()) {
            contigIndexMap.put(vcfContig.getID(), vcfContig.getContigIndex());
        }
        TreeMap<QueryInterval, List<Allele>> map = new TreeMap<QueryInterval, List<Allele>>();
        while (hetIterator.hasNext()) {
            VariantContext vc = (VariantContext)hetIterator.next();
            map.put(new QueryInterval(((Integer)contigIndexMap.get(vc.getContig())).intValue(), vc.getStart(), vc.getEnd()), vc.getGenotype(this.SAMPLE).getAlleles());
        }
        vcfReader.close();
        return map;
    }

    private static enum SetClassification {
        MISMATCHING_ALLELE,
        DIFFERENT_ALLELES,
        REFERENCE_ALLELE,
        ALTERNATE_ALLELE;

    }
}

