/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilitiesFromGenotype
extends HaplotypeProbabilities {
    private final Snp snp;
    private final double[] likelihoods;

    public HaplotypeProbabilitiesFromGenotype(Snp snp, HaplotypeBlock haplotypeBlock, double AA, double Aa, double aa) {
        super(haplotypeBlock);
        this.snp = snp;
        this.likelihoods = new double[]{AA, Aa, aa};
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.snp;
    }

    @Override
    public double[] getLikelihoods() {
        return this.likelihoods;
    }

    @Override
    public void merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesFromGenotype)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        this.likelihoods[0] = this.likelihoods[0] * other.getLikelihoods()[0];
        this.likelihoods[1] = this.likelihoods[1] * other.getLikelihoods()[1];
        this.likelihoods[2] = this.likelihoods[2] * other.getLikelihoods()[2];
    }
}

