/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.util.Arrays;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

abstract class HaplotypeProbabilitiesUsingLogLikelihoods
extends HaplotypeProbabilities {
    private final double[] loglikelihoods = new double[HaplotypeProbabilities.Genotype.values().length];

    public HaplotypeProbabilitiesUsingLogLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.getHaplotype().getFirstSnp();
    }

    @Override
    public boolean hasEvidence() {
        double[] ll = this.getLogLikelihoods();
        return ll[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v] != 0.0 || ll[HaplotypeProbabilities.Genotype.HET_ALLELE12.v] != 0.0 || ll[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v] != 0.0;
    }

    @Override
    public void merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesUsingLogLikelihoods)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesUsingLogLikelihoods o = (HaplotypeProbabilitiesUsingLogLikelihoods)other;
        this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), o.getLogLikelihoods()));
    }

    @Override
    public double[] getPosteriorProbabilities() {
        return MathUtil.pNormalizeLogProbability(this.getShiftedLogPosterior());
    }

    private double[] getShiftedLogPosterior() {
        double[] ll = this.getLogLikelihoods();
        double[] shiftedLogPosterior = new double[HaplotypeProbabilities.Genotype.values().length];
        double[] haplotypeFrequencies = this.getPriorProbablities();
        for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
            shiftedLogPosterior[g.v] = ll[g.v] + Math.log10(haplotypeFrequencies[g.v]);
        }
        return shiftedLogPosterior;
    }

    @Override
    public double[] getLikelihoods() {
        return MathUtil.pNormalizeLogProbability(this.getLogLikelihoods());
    }

    @Override
    public double[] getLogLikelihoods() {
        return this.loglikelihoods;
    }

    public void setLogLikelihoods(double[] ll) {
        assert (ll.length == HaplotypeProbabilities.Genotype.values().length);
        System.arraycopy(ll, 0, this.loglikelihoods, 0, ll.length);
    }

    @Override
    public double getLodMostProbableGenotype() {
        double[] logs = this.getShiftedLogPosterior();
        Arrays.sort(logs);
        return logs[HaplotypeProbabilities.Genotype.values().length - 1] - logs[HaplotypeProbabilities.Genotype.values().length - 2];
    }
}

