/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.Snp;

class LocusResult
implements Comparable<LocusResult> {
    private final Snp snp;
    private final DiploidGenotype expectedGenotype;
    private final DiploidGenotype mostLikelyGenotype;
    private final int allele1Count;
    private final int allele2Count;
    private final double lodGenotype;
    private final double lodExpectedSampleTumorNormal;
    private final double lodExpectedSampleNormalTumor;
    private final double lExpectedSample;
    private final double lRandomSample;

    LocusResult(Snp snp, DiploidGenotype expectedGenotype, DiploidGenotype mostLikelyGenotype, int allele1Count, int allele2Count, double lodGenotype, double lExpectedSample, double lRandomSample, double lodGenotypeTumorNormal, double lodGenotypeNormalTumor) {
        this.snp = snp;
        this.expectedGenotype = expectedGenotype;
        this.mostLikelyGenotype = mostLikelyGenotype;
        this.allele1Count = allele1Count;
        this.allele2Count = allele2Count;
        this.lodGenotype = lodGenotype;
        this.lExpectedSample = lExpectedSample;
        this.lRandomSample = lRandomSample;
        this.lodExpectedSampleTumorNormal = lodGenotypeTumorNormal;
        this.lodExpectedSampleNormalTumor = lodGenotypeNormalTumor;
    }

    public Snp getSnp() {
        return this.snp;
    }

    public DiploidGenotype getExpectedGenotype() {
        return this.expectedGenotype;
    }

    public DiploidGenotype getMostLikelyGenotype() {
        return this.mostLikelyGenotype;
    }

    public int getAllele1Count() {
        return this.allele1Count;
    }

    public int getAllele2Count() {
        return this.allele2Count;
    }

    public double getLodGenotype() {
        return this.lodGenotype;
    }

    public double getLodExpectedSampleNormalTumor() {
        return this.lodExpectedSampleNormalTumor;
    }

    public double getLodExpectedSampleTumorNormal() {
        return this.lodExpectedSampleTumorNormal;
    }

    public double lExpectedSample() {
        return this.lExpectedSample;
    }

    public double lRandomSample() {
        return this.lRandomSample;
    }

    @Override
    public int compareTo(LocusResult that) {
        return this.snp.compareTo(that.snp);
    }
}

