/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SolexaNoiseFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import picard.PicardException;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.BasecallsConverter;
import picard.illumina.IlluminaBasecallsToSam;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class ClusterDataToSamConverter
implements BasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean hasSampleBarcode;
    private final boolean hasMolecularBarcode;
    private final int[] templateIndices;
    private final int[] sampleBarcodeIndices;
    private final int[] molecularBarcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;
    private String molecularIndexTag = "RX";
    private String molecularIndexQualityTag = "QX";
    private final String molecularIndexDelimiter = "-";
    private List<String> tagPerMolecularIndex = Collections.emptyList();

    public ClusterDataToSamConverter(String runBarcode, String readGroupId, ReadStructure readStructure, List<AdapterPair> adapters) {
        this.readGroupId = readGroupId;
        this.readNameEncoder = new IlluminaReadNameEncoder(runBarcode);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.hasSampleBarcode = !readStructure.sampleBarcodes.isEmpty();
        this.hasMolecularBarcode = !readStructure.molecularBarcode.isEmpty();
        this.adapterMarker = adapters.isEmpty() ? null : new AdapterMarker(adapters.toArray(new AdapterPair[adapters.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.sampleBarcodeIndices = readStructure.sampleBarcodes.getIndices();
        this.molecularBarcodeIndices = readStructure.molecularBarcode.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    public ClusterDataToSamConverter withMolecularIndexTag(String molecularIndexTag) {
        if (molecularIndexTag == null) {
            throw new IllegalArgumentException("Molecular index tag was null");
        }
        this.molecularIndexTag = molecularIndexTag;
        return this;
    }

    public ClusterDataToSamConverter withMolecularIndexQualityTag(String molecularIndexQualityTag) {
        if (molecularIndexQualityTag == null) {
            throw new IllegalArgumentException("Molecular index quality tag was null");
        }
        this.molecularIndexQualityTag = molecularIndexQualityTag;
        return this;
    }

    public ClusterDataToSamConverter withTagPerMolecularIndex(List<String> tagPerMolecularIndex) {
        if (tagPerMolecularIndex == null) {
            throw new IllegalArgumentException("Null given for tagPerMolecularIndex");
        }
        this.tagPerMolecularIndex = tagPerMolecularIndex;
        return this;
    }

    private SAMRecord createSamRecord(ReadData readData, String readName, boolean isPf, boolean firstOfPair, String unmatchedBarcode, List<String> molecularIndexes, List<String> molecularIndexQualities) {
        SAMRecord sam = new SAMRecord(null);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute(SAMTag.RG.name(), (Object)this.readGroupId);
        }
        if (unmatchedBarcode != null) {
            sam.setAttribute(SAMTag.BC.name(), (Object)unmatchedBarcode);
        }
        if (!molecularIndexes.isEmpty()) {
            if (!this.molecularIndexTag.isEmpty()) {
                sam.setAttribute(this.molecularIndexTag, (Object)String.join((CharSequence)"-", molecularIndexes));
            }
            if (!this.molecularIndexQualityTag.isEmpty()) {
                sam.setAttribute(this.molecularIndexQualityTag, (Object)String.join((CharSequence)"-", molecularIndexQualities));
            }
            if (!this.tagPerMolecularIndex.isEmpty()) {
                if (this.tagPerMolecularIndex.size() != molecularIndexes.size()) {
                    throw new PicardException("Found " + molecularIndexes.size() + " molecular indexes but only " + this.tagPerMolecularIndex.size() + " SAM tags given.");
                }
                for (int i = 0; i < this.tagPerMolecularIndex.size(); ++i) {
                    sam.setAttribute(this.tagPerMolecularIndex.get(i), (Object)molecularIndexes.get(i));
                }
            }
        }
        return sam;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
        SAMRecord firstOfPair;
        List<String> molecularIndexQualities;
        List<String> molecularIndexes;
        IlluminaBasecallsToSam.SAMRecordsForCluster ret = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String readName = this.readNameEncoder.generateReadName(cluster, null);
        String unmatchedBarcode = null;
        if (this.hasSampleBarcode && cluster.getMatchedBarcode() == null) {
            byte[][] barcode = new byte[this.sampleBarcodeIndices.length][];
            for (int i = 0; i < this.sampleBarcodeIndices.length; ++i) {
                barcode[i] = cluster.getRead(this.sampleBarcodeIndices[i]).getBases();
            }
            unmatchedBarcode = IlluminaUtil.barcodeSeqsToString(barcode).replace('.', 'N');
        }
        if (this.hasMolecularBarcode) {
            molecularIndexes = new ArrayList();
            molecularIndexQualities = new ArrayList();
            for (int i = 0; i < this.molecularBarcodeIndices.length; ++i) {
                molecularIndexes.add(new String(cluster.getRead(this.molecularBarcodeIndices[i]).getBases()).replace('.', 'N'));
                molecularIndexQualities.add(SAMUtils.phredToFastq((byte[])cluster.getRead(this.molecularBarcodeIndices[i]).getQualities()));
            }
        } else {
            molecularIndexes = Collections.emptyList();
            molecularIndexQualities = Collections.emptyList();
        }
        ret.records[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[0]), readName, cluster.isPf(), true, unmatchedBarcode, molecularIndexes, molecularIndexQualities);
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            ret.records[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[1]), readName, cluster.isPf(), false, unmatchedBarcode, molecularIndexes, molecularIndexQualities);
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead(firstOfPair);
            }
        }
        return ret;
    }
}

