/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CigarUtil;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.sam.HitsForInsert;
import picard.sam.MultiHitAlignedReadIterator;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private int crossSpeciesReads = 0;
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 1000000, "Merged", "records");
    private final File unmappedBamFile;
    private final File targetBamFile;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final List<String> attributesToRemove = new ArrayList<String>();
    private Set<String> attributesToReverse = new TreeSet<String>(SAMRecord.TAGS_TO_REVERSE);
    private Set<String> attributesToReverseComplement = new TreeSet<String>(SAMRecord.TAGS_TO_REVERSE_COMPLEMENT);
    protected final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private int maxRecordsInRam = 500000;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private boolean keepAlignerProperPairFlags = false;
    private boolean addMateCigar = false;
    private boolean unmapContaminantReads = false;
    private UnmappingReadStrategy unmappingReadsStrategy = UnmappingReadStrategy.DO_NOT_CHANGE;
    private boolean addPGTagToReads = true;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        public boolean filterOut(SAMRecord record) {
            return AbstractAlignmentMerger.this.ignoreAlignment(record);
        }

        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };
    private boolean includeSecondaryAlignments = true;

    protected abstract SAMSequenceDictionary getDictionaryForMergedBam();

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sam) {
        return false;
    }

    protected boolean isContaminant(HitsForInsert hits) {
        return false;
    }

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, SAMProgramRecord programRecord, List<String> attributesToRetain, List<String> attributesToRemove, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean addMateCigar, boolean unmapContaminantReads) {
        this(unmappedBamFile, targetBamFile, referenceFasta, clipAdapters, bisulfiteSequence, alignedReadsOnly, programRecord, attributesToRetain, attributesToRemove, read1BasesTrimmed, read2BasesTrimmed, expectedOrientations, sortOrder, primaryAlignmentSelectionStrategy, addMateCigar, unmapContaminantReads, UnmappingReadStrategy.DO_NOT_CHANGE);
    }

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, SAMProgramRecord programRecord, List<String> attributesToRetain, List<String> attributesToRemove, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy, boolean addMateCigar, boolean unmapContaminantReads, UnmappingReadStrategy unmappingReadsStrategy) {
        IOUtil.assertFileIsReadable((File)unmappedBamFile);
        IOUtil.assertFileIsWritable((File)targetBamFile);
        IOUtil.assertFileIsReadable((File)referenceFasta);
        this.unmappedBamFile = unmappedBamFile;
        this.targetBamFile = targetBamFile;
        this.referenceFasta = referenceFasta;
        this.refSeq = new ReferenceSequenceFileWalker(referenceFasta);
        this.clipAdapters = clipAdapters;
        this.bisulfiteSequence = bisulfiteSequence;
        this.alignedReadsOnly = alignedReadsOnly;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (programRecord != null) {
            this.setProgramRecord(programRecord);
        }
        if (attributesToRetain != null) {
            this.attributesToRetain.addAll(attributesToRetain);
        }
        if (attributesToRemove != null) {
            this.attributesToRemove.addAll(attributesToRemove);
            if (!this.attributesToRetain.isEmpty()) {
                this.attributesToRemove.stream().filter(this.attributesToRetain::contains).peek(a -> this.log.info(new Object[]{"Overriding retaining the " + a + " tag since 'remove' overrides 'retain'."})).forEach(this.attributesToRetain::remove);
            }
        }
        this.read1BasesTrimmed = read1BasesTrimmed;
        this.read2BasesTrimmed = read2BasesTrimmed;
        this.expectedOrientations = expectedOrientations;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.addMateCigar = addMateCigar;
        this.unmapContaminantReads = unmapContaminantReads;
        this.unmappingReadsStrategy = unmappingReadsStrategy;
    }

    public Set<String> getAttributesToReverse() {
        return this.attributesToReverse;
    }

    public void setAttributesToReverse(Set<String> attributesToReverse) {
        this.attributesToReverse = attributesToReverse;
    }

    public Set<String> getAttributesToReverseComplement() {
        return this.attributesToReverseComplement;
    }

    public void setAttributesToReverseComplement(Set<String> attributesToReverseComplement) {
        this.attributesToReverseComplement = attributesToReverseComplement;
    }

    public void setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
    }

    public void setAddPGTagToReads(boolean addPGTagToReads) {
        this.addPGTagToReads = addPGTagToReads;
    }

    private void maybeSetPgTag(SAMRecord rec) {
        if (this.programRecord != null && this.addPGTagToReads) {
            rec.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
    }

    public void mergeAlignment(File referenceFasta) {
        Sink sink;
        SamReader unmappedSam = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(this.unmappedBamFile);
        SAMRecordIterator unmappedIterator = unmappedSam.iterator();
        this.header.setReadGroups(unmappedSam.getFileHeader().getReadGroups());
        int aligned = 0;
        int unmapped = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator((CloseableIterator<SAMRecord>)new FilteringSamIterator(this.getQuerynameSortedAlignedRecords(), this.alignmentFilter), this.primaryAlignmentSelectionStrategy);
        this.header.setSequenceDictionary(this.getDictionaryForMergedBam());
        HitsForInsert nextAligned = this.nextAligned();
        if (this.getProgramRecord() != null) {
            for (SAMProgramRecord pg : unmappedSam.getFileHeader().getProgramRecords()) {
                if (!pg.getId().equals(this.getProgramRecord().getId())) continue;
                throw new PicardException("Program Record ID already in use in unmapped BAM file.");
            }
        }
        if (this.sortOrder == SAMFileHeader.SortOrder.coordinate) {
            SortingCollection sorted1 = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(this.header), (Comparator)new SAMRecordCoordinateComparator(), (int)this.maxRecordsInRam);
            sink = new Sink((SortingCollection<SAMRecord>)sorted1);
        } else {
            SAMFileHeader header = this.header.clone();
            header.setSortOrder(this.sortOrder);
            SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, this.targetBamFile);
            writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records to output in queryname order"));
            sink = new Sink(writer);
        }
        while (unmappedIterator.hasNext()) {
            SAMRecord secondOfPair;
            SAMRecord rec = (SAMRecord)unmappedIterator.next();
            rec.setHeader(this.header);
            this.maybeSetPgTag(rec);
            if (rec.getReadPairedFlag()) {
                secondOfPair = (SAMRecord)unmappedIterator.next();
                secondOfPair.setHeader(this.header);
                this.maybeSetPgTag(secondOfPair);
                if (!rec.getReadName().equals(secondOfPair.getReadName())) {
                    throw new PicardException("Second read from pair not found in unmapped bam: " + rec.getReadName() + ", " + secondOfPair.getReadName());
                }
                if (!rec.getFirstOfPairFlag()) {
                    throw new PicardException("First record in unmapped bam is not first of pair: " + rec.getReadName());
                }
                if (!secondOfPair.getReadPairedFlag()) {
                    throw new PicardException("Second record in unmapped bam is not marked as paired: " + secondOfPair.getReadName());
                }
                if (!secondOfPair.getSecondOfPairFlag()) {
                    throw new PicardException("Second record in unmapped bam is not second of pair: " + secondOfPair.getReadName());
                }
            } else {
                secondOfPair = null;
            }
            if (nextAligned != null && rec.getReadName().equals(nextAligned.getReadName())) {
                boolean unmapDueToContaminant;
                boolean clone = nextAligned.numHits() > 1 || nextAligned.hasSupplementalHits();
                SAMRecord r1Primary = null;
                SAMRecord r2Primary = null;
                boolean bl = unmapDueToContaminant = this.unmapContaminantReads && this.isContaminant(nextAligned);
                if (rec.getReadPairedFlag()) {
                    for (int i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord secondToWrite;
                        SAMRecord firstToWrite;
                        boolean isPrimaryAlignment;
                        SAMRecord firstAligned = nextAligned.getFirstOfPair(i);
                        SAMRecord secondAligned = nextAligned.getSecondOfPair(i);
                        boolean bl2 = isPrimaryAlignment = firstAligned != null && !firstAligned.isSecondaryOrSupplementary() || secondAligned != null && !secondAligned.isSecondaryOrSupplementary();
                        if (clone) {
                            firstToWrite = this.clone(rec);
                            secondToWrite = this.clone(secondOfPair);
                        } else {
                            firstToWrite = rec;
                            secondToWrite = secondOfPair;
                        }
                        if (isPrimaryAlignment) {
                            r1Primary = firstToWrite;
                            r2Primary = secondToWrite;
                        }
                        this.transferAlignmentInfoToPairedRead(firstToWrite, secondToWrite, firstAligned, secondAligned, unmapDueToContaminant, clone);
                        if (!firstToWrite.getReadUnmappedFlag() || isPrimaryAlignment) {
                            this.addIfNotFiltered(sink, firstToWrite);
                            if (firstToWrite.getReadUnmappedFlag()) {
                                ++unmapped;
                            } else {
                                ++aligned;
                            }
                        }
                        if (secondToWrite.getReadUnmappedFlag() && !isPrimaryAlignment) continue;
                        this.addIfNotFiltered(sink, secondToWrite);
                        if (!secondToWrite.getReadUnmappedFlag()) {
                            ++aligned;
                            continue;
                        }
                        ++unmapped;
                    }
                    for (boolean isRead1 : new boolean[]{true, false}) {
                        List<SAMRecord> supplementals = isRead1 ? nextAligned.getSupplementalFirstOfPairOrFragment() : nextAligned.getSupplementalSecondOfPair();
                        SAMRecord sourceRec = isRead1 ? rec : secondOfPair;
                        SAMRecord matePrimary = isRead1 ? r2Primary : r1Primary;
                        for (SAMRecord supp : supplementals) {
                            SAMRecord out = this.clone(sourceRec);
                            this.transferAlignmentInfoToFragment(out, supp, unmapDueToContaminant, clone);
                            if (matePrimary != null) {
                                SamPairUtil.setMateInformationOnSupplementalAlignment((SAMRecord)out, (SAMRecord)matePrimary, (boolean)this.addMateCigar);
                            }
                            if (!out.getReadUnmappedFlag()) {
                                this.addIfNotFiltered(sink, out);
                                ++aligned;
                                continue;
                            }
                            ++unmapped;
                        }
                    }
                } else {
                    for (int i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord recToWrite = clone ? this.clone(rec) : rec;
                        boolean isPrimary = !nextAligned.getFragment(i).isSecondaryOrSupplementary();
                        this.transferAlignmentInfoToFragment(recToWrite, nextAligned.getFragment(i), unmapDueToContaminant, clone);
                        if (!recToWrite.getReadUnmappedFlag() || isPrimary) {
                            this.addIfNotFiltered(sink, recToWrite);
                        }
                        if (recToWrite.getReadUnmappedFlag()) {
                            ++unmapped;
                            continue;
                        }
                        ++aligned;
                    }
                    for (SAMRecord supplementalRec : nextAligned.getSupplementalFirstOfPairOrFragment()) {
                        SAMRecord recToWrite = this.clone(rec);
                        this.transferAlignmentInfoToFragment(recToWrite, supplementalRec, unmapDueToContaminant, clone);
                        if (!recToWrite.getReadUnmappedFlag()) {
                            this.addIfNotFiltered(sink, recToWrite);
                            ++aligned;
                            continue;
                        }
                        ++unmapped;
                    }
                }
                nextAligned = this.nextAligned();
                continue;
            }
            if (nextAligned != null && SAMRecordQueryNameComparator.compareReadNames((String)rec.getReadName(), (String)nextAligned.getReadName()) > 0) {
                throw new IllegalStateException("Aligned record iterator (" + nextAligned.getReadName() + ") is behind the unmapped reads (" + rec.getReadName() + ")");
            }
            if (this.alignedReadsOnly) continue;
            sink.add(rec);
            ++unmapped;
            if (secondOfPair == null) continue;
            sink.add(secondOfPair);
            ++unmapped;
        }
        unmappedIterator.close();
        if (this.alignedIterator.hasNext()) {
            throw new IllegalStateException("Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        }
        this.alignedIterator.close();
        sink.close();
        if (this.sortOrder == SAMFileHeader.SortOrder.coordinate) {
            this.header.setSortOrder(this.sortOrder);
            SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, true, this.targetBamFile);
            writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
            ProgressLogger finalProgress = new ProgressLogger(this.log, 10000000, "Written in coordinate order to output", "records");
            for (SAMRecord rec : sink.sorter) {
                if (!rec.getReadUnmappedFlag() && this.refSeq != null) {
                    AbstractAlignmentMerger.fixNmMdAndUq(rec, this.refSeq, this.bisulfiteSequence);
                }
                writer.addAlignment(rec);
                finalProgress.record(rec);
            }
            writer.close();
            sink.sorter.cleanup();
        }
        CloserUtil.close((Object)unmappedSam);
        this.log.info(new Object[]{"Wrote " + aligned + " alignment records and " + (this.alignedReadsOnly ? 0 : unmapped) + " unmapped reads."});
    }

    public static void fixNmMdAndUq(SAMRecord record, ReferenceSequenceFileWalker refSeqWalker, boolean isBisulfiteSequence) {
        byte[] referenceBases = refSeqWalker.get(record.getReferenceIndex().intValue()).getBases();
        SequenceUtil.calculateMdAndNmTags((SAMRecord)record, (byte[])referenceBases, (boolean)true, (!isBisulfiteSequence ? 1 : 0) != 0);
        if (isBisulfiteSequence) {
            record.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)record, (byte[])referenceBases, (int)0, (boolean)isBisulfiteSequence));
        }
        AbstractAlignmentMerger.fixUq(record, refSeqWalker, isBisulfiteSequence);
    }

    public static void fixUq(SAMRecord record, ReferenceSequenceFileWalker refSeqWalker, boolean isBisulfiteSequence) {
        if (record.getBaseQualities() != SAMRecord.NULL_QUALS) {
            byte[] referenceBases = refSeqWalker.get(record.getReferenceIndex().intValue()).getBases();
            record.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)record, (byte[])referenceBases, (int)0, (boolean)isBisulfiteSequence));
        }
    }

    private void addIfNotFiltered(Sink out, SAMRecord rec) {
        if (this.includeSecondaryAlignments || !rec.getNotPrimaryAlignmentFlag()) {
            out.add(rec);
            if (this.progress.record(rec) && this.crossSpeciesReads > 0) {
                this.log.info(new Object[]{String.format("%d Reads have been unmapped due to being suspected of being Cross-species contamination.", this.crossSpeciesReads)});
            }
        }
    }

    private SAMRecord clone(SAMRecord rec) {
        try {
            return (SAMRecord)rec.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PicardException("Should never happen.");
        }
    }

    private HitsForInsert nextAligned() {
        if (this.alignedIterator.hasNext()) {
            return this.alignedIterator.next();
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord unaligned, SAMRecord aligned, boolean isContaminant, boolean needsSafeReverseComplement) {
        this.setValuesFromAlignment(unaligned, aligned, needsSafeReverseComplement);
        this.updateCigarForTrimmedOrClippedBases(unaligned, aligned);
        if (SAMUtils.cigarMapsNoBasesToRef((Cigar)unaligned.getCigar())) {
            this.log.warn(new Object[]{"Record contains no unclipped bases; making unmapped: " + aligned});
            SAMUtils.makeReadUnmapped((SAMRecord)unaligned);
        } else if (SAMUtils.recordMapsEntirelyBeyondEndOfReference((SAMRecord)aligned)) {
            this.log.warn(new Object[]{"Record mapped off end of reference; making unmapped: " + aligned});
            SAMUtils.makeReadUnmapped((SAMRecord)unaligned);
        } else if (isContaminant) {
            ++this.crossSpeciesReads;
            if (this.unmappingReadsStrategy.isPopulatePaTag()) {
                unaligned.setAttribute("PA", (Object)AbstractAlignmentMerger.encodeMappingInformation(aligned));
            }
            if (this.unmappingReadsStrategy.isResetMappingInformation()) {
                unaligned.setReferenceIndex(-1);
                unaligned.setAlignmentStart(0);
                unaligned.setCigar(null);
                unaligned.setCigarString("*");
                unaligned.setAttribute(SAMTag.NM.name(), null);
            }
            unaligned.setReadUnmappedFlag(true);
            unaligned.setMappingQuality(0);
            Optional<String> optionalComment = Optional.ofNullable(unaligned.getStringAttribute(SAMTag.CO.name()));
            unaligned.setAttribute(optionalComment.map(s -> s + " | ").orElse("") + SAMTag.CO.name(), (Object)"Cross-species contamination");
        }
    }

    private static String encodeMappingInformation(SAMRecord rec) {
        return String.join((CharSequence)",", rec.getContig(), Integer.valueOf(rec.getAlignmentStart()).toString(), rec.getCigarString(), Integer.valueOf(rec.getMappingQuality()).toString(), AbstractAlignmentMerger.getStringOfNullable(rec.getIntegerAttribute(SAMTag.NM.name()))) + ";";
    }

    private static String getStringOfNullable(Object obj) {
        return Optional.ofNullable(obj).map(Object::toString).orElse("");
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord firstUnaligned, SAMRecord secondUnaligned, SAMRecord firstAligned, SAMRecord secondAligned, boolean isContaminant, boolean needsSafeReverseComplement) {
        if (firstAligned != null) {
            this.transferAlignmentInfoToFragment(firstUnaligned, firstAligned, isContaminant, needsSafeReverseComplement);
        }
        if (secondAligned != null) {
            this.transferAlignmentInfoToFragment(secondUnaligned, secondAligned, isContaminant, needsSafeReverseComplement);
        }
        if (this.isClipOverlappingReads()) {
            AbstractAlignmentMerger.clipForOverlappingReads(firstUnaligned, secondUnaligned);
        }
        SamPairUtil.setMateInfo((SAMRecord)secondUnaligned, (SAMRecord)firstUnaligned, (boolean)this.addMateCigar);
        if (!this.keepAlignerProperPairFlags) {
            SamPairUtil.setProperPairFlags((SAMRecord)secondUnaligned, (SAMRecord)firstUnaligned, this.expectedOrientations);
        }
    }

    protected static void clipForOverlappingReads(SAMRecord read1, SAMRecord read2) {
        if (!read1.getReadUnmappedFlag() && !read2.getReadUnmappedFlag() && read1.getReadNegativeStrandFlag() != read2.getReadNegativeStrandFlag()) {
            SAMRecord neg;
            SAMRecord pos = read1.getReadNegativeStrandFlag() ? read2 : read1;
            SAMRecord sAMRecord = neg = read1.getReadNegativeStrandFlag() ? read1 : read2;
            if (pos.getAlignmentStart() < neg.getAlignmentEnd()) {
                int posDiff = pos.getAlignmentEnd() - neg.getAlignmentEnd();
                int negDiff = pos.getAlignmentStart() - neg.getAlignmentStart();
                if (posDiff > 0) {
                    ArrayList elems = new ArrayList(pos.getCigar().getCigarElements());
                    Collections.reverse(elems);
                    int clipped = AbstractAlignmentMerger.lengthOfSoftClipping(elems.iterator());
                    int clipFrom = pos.getReadLength() - posDiff - clipped + 1;
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)pos, (int)Math.min(pos.getReadLength(), clipFrom));
                    AbstractAlignmentMerger.removeNmMdAndUqTags(pos);
                }
                if (negDiff > 0) {
                    int clipped = AbstractAlignmentMerger.lengthOfSoftClipping(neg.getCigar().getCigarElements().iterator());
                    int clipFrom = neg.getReadLength() - negDiff - clipped + 1;
                    CigarUtil.softClip3PrimeEndOfRead((SAMRecord)neg, (int)Math.min(neg.getReadLength(), clipFrom));
                    AbstractAlignmentMerger.removeNmMdAndUqTags(neg);
                }
            }
        }
    }

    private static int lengthOfSoftClipping(Iterator<CigarElement> iterator) {
        CigarElement elem;
        int clipped = 0;
        while (iterator.hasNext() && ((elem = iterator.next()).getOperator() == CigarOperator.SOFT_CLIP || elem.getOperator() == CigarOperator.HARD_CLIP)) {
            if (elem.getOperator() != CigarOperator.SOFT_CLIP) continue;
            clipped = elem.getLength();
        }
        return clipped;
    }

    protected void setValuesFromAlignment(SAMRecord rec, SAMRecord alignment, boolean needsSafeReverseComplement) {
        for (SAMRecord.SAMTagAndValue attr : alignment.getAttributes()) {
            if (this.isReservedTag(attr.tag) && !this.attributesToRetain.contains(attr.tag) || this.attributesToRemove.contains(attr.tag)) continue;
            rec.setAttribute(attr.tag, attr.value);
        }
        rec.setReadUnmappedFlag(alignment.getReadUnmappedFlag());
        rec.setReferenceName(alignment.getReferenceName());
        rec.setAlignmentStart(alignment.getAlignmentStart());
        rec.setReadNegativeStrandFlag(alignment.getReadNegativeStrandFlag());
        rec.setNotPrimaryAlignmentFlag(alignment.getNotPrimaryAlignmentFlag());
        rec.setSupplementaryAlignmentFlag(alignment.getSupplementaryAlignmentFlag());
        if (!alignment.getReadUnmappedFlag()) {
            rec.setCigar(alignment.getCigar());
            rec.setMappingQuality(alignment.getMappingQuality());
        }
        if (rec.getReadPairedFlag()) {
            rec.setProperPairFlag(alignment.getProperPairFlag());
        }
        if (rec.getReadNegativeStrandFlag()) {
            rec.reverseComplement(this.attributesToReverseComplement, this.attributesToReverse, !needsSafeReverseComplement);
        }
    }

    private static Cigar createNewCigarIfMapsOffEndOfReference(SAMFileHeader header, boolean isUnmapped, int referenceIndex, int alignmentEnd, int readLength, Cigar oldCigar) {
        SAMSequenceRecord refseq;
        int overhang;
        Cigar newCigar = null;
        if (!isUnmapped && (overhang = alignmentEnd - (refseq = header.getSequence(referenceIndex)).getSequenceLength()) > 0) {
            int clipFrom = readLength - overhang + 1;
            CigarElement cigarElement = oldCigar.getCigarElement(oldCigar.getCigarElements().size() - 1);
            if (CigarOperator.SOFT_CLIP == cigarElement.getOperator()) {
                clipFrom -= cigarElement.getLength();
            }
            List newCigarElements = CigarUtil.softClipEndOfRead((int)clipFrom, (List)oldCigar.getCigarElements());
            newCigar = new Cigar(newCigarElements);
        }
        return newCigar;
    }

    public static void createNewCigarsIfMapsOffEndOfReference(SAMRecord rec) {
        Cigar readCigar;
        if (!rec.getReadUnmappedFlag() && null != (readCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getReadUnmappedFlag(), rec.getReferenceIndex(), rec.getAlignmentEnd(), rec.getReadLength(), rec.getCigar()))) {
            rec.setCigar(readCigar);
        }
        if (SAMUtils.hasMateCigar((SAMRecord)rec)) {
            Cigar mateCigar = SAMUtils.getMateCigar((SAMRecord)rec);
            mateCigar = AbstractAlignmentMerger.createNewCigarIfMapsOffEndOfReference(rec.getHeader(), rec.getMateUnmappedFlag(), rec.getMateReferenceIndex(), SAMUtils.getMateAlignmentEnd((SAMRecord)rec), mateCigar.getReadLength(), mateCigar);
            if (null != mateCigar) {
                rec.setAttribute(SAMTag.MC.name(), (Object)mateCigar.toString());
            }
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord rec, SAMRecord alignment) {
        int alignmentReadLength = alignment.getReadLength();
        int originalReadLength = rec.getReadLength();
        int trimmed = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int notWritten = originalReadLength - (alignmentReadLength + trimmed);
        AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(rec);
        rec.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar((Cigar)rec.getCigar(), (boolean)rec.getReadNegativeStrandFlag(), (int)notWritten, (int)trimmed));
        if (this.clipAdapters && rec.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead((SAMRecord)rec, (int)rec.getIntegerAttribute("XT"));
            AbstractAlignmentMerger.removeNmMdAndUqTags(rec);
        }
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord pg) {
        if (this.programRecord != null) {
            throw new IllegalStateException("Cannot set program record more than once on alignment merger.");
        }
        this.programRecord = pg;
        this.header.addProgramRecord(pg);
        SAMUtils.chainSAMProgramRecord((SAMFileHeader)this.header, (SAMProgramRecord)pg);
    }

    protected boolean isReservedTag(String tag) {
        char firstCharOfTag = tag.charAt(0);
        if (Character.isLowerCase(firstCharOfTag)) {
            return true;
        }
        for (char c : RESERVED_ATTRIBUTE_STARTS) {
            if (firstCharOfTag != c) continue;
            return true;
        }
        return false;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean clipOverlappingReads) {
        this.clipOverlappingReads = clipOverlappingReads;
    }

    public boolean isKeepAlignerProperPairFlags() {
        return this.keepAlignerProperPairFlags;
    }

    public void setKeepAlignerProperPairFlags(boolean keepAlignerProperPairFlags) {
        this.keepAlignerProperPairFlags = keepAlignerProperPairFlags;
    }

    public void setIncludeSecondaryAlignments(boolean includeSecondaryAlignments) {
        this.includeSecondaryAlignments = includeSecondaryAlignments;
    }

    public void close() {
        CloserUtil.close((Object)this.refSeq);
    }

    private static void removeNmMdAndUqTags(SAMRecord rec) {
        rec.setAttribute(SAMTag.NM.name(), null);
        rec.setAttribute(SAMTag.MD.name(), null);
        rec.setAttribute(SAMTag.UQ.name(), null);
    }

    public static enum UnmappingReadStrategy {
        COPY_TO_TAG(false, true),
        DO_NOT_CHANGE(false, false),
        MOVE_TO_TAG(true, true);

        private final boolean resetMappingInformation;
        private final boolean populatePATag;

        private UnmappingReadStrategy(boolean resetMappingInformation, boolean populatePATag) {
            this.resetMappingInformation = resetMappingInformation;
            this.populatePATag = populatePATag;
        }

        public boolean isResetMappingInformation() {
            return this.resetMappingInformation;
        }

        public boolean isPopulatePaTag() {
            return this.populatePATag;
        }
    }

    private static class Sink {
        private final SAMFileWriter writer;
        private final SortingCollection<SAMRecord> sorter;

        public Sink(SAMFileWriter writer) {
            this.writer = writer;
            this.sorter = null;
        }

        public Sink(SortingCollection<SAMRecord> sorter) {
            this.writer = null;
            this.sorter = sorter;
        }

        void add(SAMRecord rec) {
            if (this.writer != null) {
                this.writer.addAlignment(rec);
            }
            if (this.sorter != null) {
                this.sorter.add((Object)rec);
            }
        }

        void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.sorter != null) {
                this.sorter.doneAdding();
            }
        }
    }
}

