/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Replace read groups in a BAM file.This tool enables the user to replace all read groups in the INPUT file with a single new read group and assign all reads to this read group in the OUTPUT BAM file.<br /><br />For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /> This tool accepts INPUT BAM and SAM files or URLs from the Global Alliance for Genomics and Health (GA4GH) (see http://ga4gh.org/#/documentation).<h4>Usage example:</h4><pre>java -jar picard.jar AddOrReplaceReadGroups \\<br />      I=input.bam \\<br />      O=output.bam \\<br />      RGID=4 \\<br />      RGLB=lib1 \\<br />      RGPL=illumina \\<br />      RGPU=unit1 \\<br />      RGSM=20</pre><hr />", oneLineSummary="Replace read groups in a BAM file.", programGroup=SamOrBam.class)
@DocumentedFeature
public class AddOrReplaceReadGroups
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replace read groups in a BAM file.";
    static final String USAGE_DETAILS = "This tool enables the user to replace all read groups in the INPUT file with a single new read group and assign all reads to this read group in the OUTPUT BAM file.<br /><br />For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /> This tool accepts INPUT BAM and SAM files or URLs from the Global Alliance for Genomics and Health (GA4GH) (see http://ga4gh.org/#/documentation).<h4>Usage example:</h4><pre>java -jar picard.jar AddOrReplaceReadGroups \\<br />      I=input.bam \\<br />      O=output.bam \\<br />      RGID=4 \\<br />      RGLB=lib1 \\<br />      RGPL=illumina \\<br />      RGPU=unit1 \\<br />      RGSM=20</pre><hr />";
    @Argument(shortName="I", doc="Input file (BAM or SAM or a GA4GH url).")
    public String INPUT = null;
    @Argument(shortName="O", doc="Output file (BAM or SAM).")
    public File OUTPUT = null;
    @Argument(shortName="SO", optional=true, doc="Optional sort order to output in. If not supplied OUTPUT is in the same order as INPUT.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Argument(shortName="ID", doc="Read Group ID")
    public String RGID = "1";
    @Argument(shortName="LB", doc="Read Group library")
    public String RGLB;
    @Argument(shortName="PL", doc="Read Group platform (e.g. illumina, solid)")
    public String RGPL;
    @Argument(shortName="PU", doc="Read Group platform unit (eg. run barcode)")
    public String RGPU;
    @Argument(shortName="SM", doc="Read Group sample name")
    public String RGSM;
    @Argument(shortName="CN", doc="Read Group sequencing center name", optional=true)
    public String RGCN;
    @Argument(shortName="DS", doc="Read Group description", optional=true)
    public String RGDS;
    @Argument(shortName="DT", doc="Read Group run date", optional=true)
    public Iso8601Date RGDT;
    @Argument(shortName="KS", doc="Read Group key sequence", optional=true)
    public String RGKS;
    @Argument(shortName="FO", doc="Read Group flow order", optional=true)
    public String RGFO;
    @Argument(shortName="PI", doc="Read Group predicted insert size", optional=true)
    public Integer RGPI;
    @Argument(shortName="PG", doc="Read Group program group", optional=true)
    public String RGPG;
    @Argument(shortName="PM", doc="Read Group platform model", optional=true)
    public String RGPM;
    private final Log log = Log.getInstance(AddOrReplaceReadGroups.class);

    public static void main(String[] argv) {
        new AddOrReplaceReadGroups().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertInputIsValid((String)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((String)this.INPUT));
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.RGID);
        rg.setLibrary(this.RGLB);
        rg.setPlatform(this.RGPL);
        rg.setSample(this.RGSM);
        rg.setPlatformUnit(this.RGPU);
        if (this.RGCN != null) {
            rg.setSequencingCenter(this.RGCN);
        }
        if (this.RGDS != null) {
            rg.setDescription(this.RGDS);
        }
        if (this.RGDT != null) {
            rg.setRunDate((Date)this.RGDT);
        }
        if (this.RGPI != null) {
            rg.setPredictedMedianInsertSize(this.RGPI);
        }
        if (this.RGPG != null) {
            rg.setProgramGroup(this.RGPG);
        }
        if (this.RGPM != null) {
            rg.setPlatformModel(this.RGPM);
        }
        if (this.RGKS != null) {
            rg.setKeySequence(this.RGKS);
        }
        if (this.RGFO != null) {
            rg.setFlowOrder(this.RGFO);
        }
        this.log.info(new Object[]{String.format("Created read group ID=%s PL=%s LB=%s SM=%s%n", rg.getId(), rg.getPlatform(), rg.getLibrary(), rg.getSample())});
        SAMFileHeader inHeader = in.getFileHeader();
        SAMFileHeader outHeader = inHeader.clone();
        outHeader.setReadGroups(Arrays.asList(rg));
        if (this.SORT_ORDER != null) {
            outHeader.setSortOrder(this.SORT_ORDER);
        }
        SAMFileWriter outWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, outHeader.getSortOrder() == inHeader.getSortOrder(), this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log);
        for (SAMRecord read : in) {
            read.setAttribute(SAMTag.RG.name(), (Object)this.RGID);
            outWriter.addAlignment(read);
            progress.record(read);
        }
        CloserUtil.close((Object)in);
        outWriter.close();
        return 0;
    }
}

