/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceDictionaryCodec;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.AsciiWriter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.Fasta;

@DocumentedFeature
@CommandLineProgramProperties(summary="Creates a sequence dictionary for a reference sequence.  This tool creates a sequence dictionary file (with \".dict\" extension) from a reference sequence provided in FASTA format, which is required by many processing and analysis tools. The output file contains a header but no SAMRecords, and the header contains only sequence records.<br /><br />The reference sequence can be gzipped (both .fasta and .fasta.gz are supported).<h4>Usage example:</h4><pre>java -jar picard.jar CreateSequenceDictionary \\ <br />      R=reference.fasta \\ <br />      O=reference.dict</pre><hr />", oneLineSummary="Creates a sequence dictionary for a reference sequence.  ", programGroup=Fasta.class)
public class CreateSequenceDictionary
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Creates a sequence dictionary for a reference sequence.  ";
    static final String USAGE_DETAILS = "This tool creates a sequence dictionary file (with \".dict\" extension) from a reference sequence provided in FASTA format, which is required by many processing and analysis tools. The output file contains a header but no SAMRecords, and the header contains only sequence records.<br /><br />The reference sequence can be gzipped (both .fasta and .fasta.gz are supported).<h4>Usage example:</h4><pre>java -jar picard.jar CreateSequenceDictionary \\ <br />      R=reference.fasta \\ <br />      O=reference.dict</pre><hr />";
    private static final Log logger = Log.getInstance(CreateSequenceDictionary.class);
    @Argument(doc="Output SAM file containing only the sequence dictionary. By default it will use the base name of the input reference with the .dict extension", shortName="O", optional=true)
    public File OUTPUT;
    @Argument(shortName="AS", doc="Put into AS field of sequence dictionary entry if supplied", optional=true)
    public String GENOME_ASSEMBLY;
    @Argument(shortName="UR", doc="Put into UR field of sequence dictionary entry.  If not supplied, input reference file is used", optional=true)
    public String URI;
    @Argument(shortName="SP", doc="Put into SP field of sequence dictionary entry", optional=true)
    public String SPECIES;
    @Argument(doc="Make sequence name the first word from the > line in the fasta file.  By default the entire contents of the > line is used, excluding leading and trailing whitespace.")
    public boolean TRUNCATE_NAMES_AT_WHITESPACE = true;
    @Argument(doc="Stop after writing this many sequences.  For testing.")
    public int NUM_SEQUENCES = Integer.MAX_VALUE;
    private final MessageDigest md5;

    public CreateSequenceDictionary() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PicardException("MD5 algorithm not found", e);
        }
    }

    public static void main(String[] argv) {
        System.exit(new CreateSequenceDictionary().instanceMain(argv));
    }

    @Deprecated
    public SAMSequenceDictionary makeSequenceDictionary(File referenceFile) {
        ReferenceSequence refSeq;
        ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)referenceFile, (boolean)this.TRUNCATE_NAMES_AT_WHITESPACE);
        ArrayList<SAMSequenceRecord> ret = new ArrayList<SAMSequenceRecord>();
        HashSet<String> sequenceNames = new HashSet<String>();
        for (int numSequences = 0; numSequences < this.NUM_SEQUENCES && (refSeq = refSeqFile.nextSequence()) != null; ++numSequences) {
            if (sequenceNames.contains(refSeq.getName())) {
                throw new PicardException("Sequence name appears more than once in reference: " + refSeq.getName());
            }
            sequenceNames.add(refSeq.getName());
            ret.add(this.makeSequenceRecord(refSeq));
        }
        return new SAMSequenceDictionary(ret);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.URI == null) {
            this.URI = "file:" + this.referenceSequence.getReferenceFile().getAbsolutePath();
        }
        if (this.OUTPUT == null) {
            this.OUTPUT = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence((File)this.referenceSequence.getReferenceFile());
            logger.info(new Object[]{"Output dictionary will be written in ", this.OUTPUT});
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new CreateSeqDictReferenceArgumentCollection();
    }

    @Override
    protected int doWork() {
        if (this.OUTPUT.exists()) {
            throw new PicardException(this.OUTPUT.getAbsolutePath() + " already exists.  Delete this file and try again, or specify a different output file.");
        }
        SortingCollection<String> sequenceNames = this.makeSortingCollection();
        try (BufferedWriter writer = this.makeWriter();){
            ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE, (boolean)this.TRUNCATE_NAMES_AT_WHITESPACE);
            SAMSequenceDictionaryCodec samDictCodec = new SAMSequenceDictionaryCodec(writer);
            samDictCodec.encodeHeaderLine(false);
            ReferenceSequence refSeq = refSeqFile.nextSequence();
            while (refSeq != null) {
                SAMSequenceRecord samSequenceRecord = this.makeSequenceRecord(refSeq);
                samDictCodec.encodeSequenceRecord(samSequenceRecord);
                sequenceNames.add((Object)refSeq.getName());
                refSeq = refSeqFile.nextSequence();
            }
        }
        catch (FileNotFoundException e) {
            throw new PicardException("File " + this.OUTPUT.getAbsolutePath() + " not found");
        }
        catch (IOException e) {
            throw new PicardException("Can't write to or close output file " + this.OUTPUT.getAbsolutePath());
        }
        CloseableIterator iterator = sequenceNames.iterator();
        if (!iterator.hasNext()) {
            return 0;
        }
        String current = (String)iterator.next();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (current.equals(next)) {
                this.OUTPUT.delete();
                throw new PicardException("Sequence name " + current + " appears more than once in reference file");
            }
            current = next;
        }
        return 0;
    }

    private BufferedWriter makeWriter() throws FileNotFoundException {
        return new BufferedWriter((Writer)new AsciiWriter((OutputStream)(this.CREATE_MD5_FILE ? new Md5CalculatingOutputStream((OutputStream)new FileOutputStream(this.OUTPUT, false), new File(this.OUTPUT.getAbsolutePath() + ".md5")) : new FileOutputStream(this.OUTPUT))));
    }

    private SAMSequenceRecord makeSequenceRecord(ReferenceSequence refSeq) {
        SAMSequenceRecord ret = new SAMSequenceRecord(refSeq.getName(), refSeq.length());
        byte[] bases = refSeq.getBases();
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase((byte)bases[i]);
        }
        ret.setAttribute("M5", this.md5Hash(bases));
        if (this.GENOME_ASSEMBLY != null) {
            ret.setAttribute("AS", this.GENOME_ASSEMBLY);
        }
        ret.setAttribute("UR", this.URI);
        if (this.SPECIES != null) {
            ret.setAttribute("SP", this.SPECIES);
        }
        return ret;
    }

    private String md5Hash(byte[] bytes) {
        this.md5.reset();
        this.md5.update(bytes);
        String s = new BigInteger(1, this.md5.digest()).toString(16);
        if (s.length() != 32) {
            String zeros = "00000000000000000000000000000000";
            s = "00000000000000000000000000000000".substring(0, 32 - s.length()) + s;
        }
        return s;
    }

    private SortingCollection<String> makeSortingCollection() {
        String name = this.getClass().getSimpleName();
        File tmpDir = IOUtil.createTempDir((String)name, null);
        tmpDir.deleteOnExit();
        long maxNamesInRam = Runtime.getRuntime().maxMemory() / 256L / 10L;
        return SortingCollection.newInstance(String.class, (SortingCollection.Codec)new StringCodec(), String::compareTo, (int)((int)Math.min(maxNamesInRam, Integer.MAX_VALUE)), (File[])new File[]{tmpDir});
    }

    private static class StringCodec
    implements SortingCollection.Codec<String> {
        private DataInputStream dis;
        private DataOutputStream dos;

        private StringCodec() {
        }

        public StringCodec clone() {
            return new StringCodec();
        }

        public void setOutputStream(OutputStream os) {
            this.dos = new DataOutputStream(os);
        }

        public void setInputStream(InputStream is) {
            this.dis = new DataInputStream(is);
        }

        public void encode(String str) {
            try {
                this.dos.writeUTF(str);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }

        public String decode() {
            try {
                return this.dis.readUTF();
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                throw new PicardException("Exception reading sequence name from temporary file.", e);
            }
        }
    }

    public static class CreateSeqDictReferenceArgumentCollection
    implements ReferenceArgumentCollection {
        @Argument(doc="Input reference fasta or fasta.gz", shortName="R")
        public File REFERENCE;

        @Override
        public File getReferenceFile() {
            return this.REFERENCE;
        }
    }
}

