/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Convert a BAM file to a SAM file, or SAM to BAM.\nInput and output formats are determined by file extension.", oneLineSummary="Convert a BAM file to a SAM file, or a SAM to a BAM", programGroup=SamOrBam.class)
@DocumentedFeature
public class SamFormatConverter
extends CommandLineProgram {
    private static final String PROGRAM_VERSION = "1.0";
    @Argument(doc="The BAM or SAM file to parse.", shortName="I")
    public File INPUT;
    @Argument(doc="The BAM or SAM output file. ", shortName="O")
    public File OUTPUT;

    public static void main(String[] argv) {
        new SamFormatConverter().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SAMFileWriter writer = new SAMFileWriterFactory().makeWriter(reader.getFileHeader(), true, this.OUTPUT, this.REFERENCE_SEQUENCE);
        if (this.CREATE_INDEX.booleanValue() && writer.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(SamFormatConverter.class));
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        CloserUtil.close((Object)reader);
        writer.close();
        return 0;
    }
}

