/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Sorts a SAM or BAM file.  This tool sorts the input SAM or BAM file by coordinate, queryname (QNAME), or some other property of the SAM record. The SortOrder of a SAM/BAM file is found in the SAM file header tag @HD in the field labeled SO.  <p>For a coordinate sorted SAM/BAM file, read alignments are sorted first by the reference sequence name (RNAME) field using the reference sequence dictionary (@SQ tag).  Alignments within these subgroups are secondarily sorted using the left-most mapping position of the read (POS).  Subsequent to this sorting scheme, alignments are listed arbitrarily.</p>For queryname-sorted alignments, all alignments are grouped using the queryname field but the alignments are not necessarily sorted within these groups.  Reads having the same queryname are derived from the same template.  <h4>Usage example:</h4><pre>java -jar picard.jar SortSam \\<br />      I=input.bam \\<br />      O=sorted.bam \\<br />      SORT_ORDER=coordinate</pre><hr />", oneLineSummary="Sorts a SAM or BAM file.  ", programGroup=SamOrBam.class)
@DocumentedFeature
public class SortSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Sorts a SAM or BAM file.  ";
    static final String USAGE_DETAILS = "This tool sorts the input SAM or BAM file by coordinate, queryname (QNAME), or some other property of the SAM record. The SortOrder of a SAM/BAM file is found in the SAM file header tag @HD in the field labeled SO.  <p>For a coordinate sorted SAM/BAM file, read alignments are sorted first by the reference sequence name (RNAME) field using the reference sequence dictionary (@SQ tag).  Alignments within these subgroups are secondarily sorted using the left-most mapping position of the read (POS).  Subsequent to this sorting scheme, alignments are listed arbitrarily.</p>For queryname-sorted alignments, all alignments are grouped using the queryname field but the alignments are not necessarily sorted within these groups.  Reads having the same queryname are derived from the same template.  <h4>Usage example:</h4><pre>java -jar picard.jar SortSam \\<br />      I=input.bam \\<br />      O=sorted.bam \\<br />      SORT_ORDER=coordinate</pre><hr />";
    @Argument(doc="The BAM or SAM file to sort.", shortName="I")
    public File INPUT;
    @Argument(doc="The sorted BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Argument(shortName="SO", doc="Sort order of output file")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private final Log log = Log.getInstance(SortSam.class);

    public static void main(String[] argv) {
        new SortSam().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        reader.getFileHeader().setSortOrder(this.SORT_ORDER);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), false, this.OUTPUT);
        writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records from a sorting collection"));
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Read");
        for (SAMRecord rec : reader) {
            writer.addAlignment(rec);
            progress.record(rec);
        }
        this.log.info(new Object[]{"Finished reading inputs, merging and writing to output now."});
        CloserUtil.close((Object)reader);
        writer.close();
        return 0;
    }
}

