/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.util.Histogram;
import java.util.List;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

abstract class ElcDuplicatesFinder {
    protected final int maxReadLength;
    protected final double maxDiffRate;
    protected int minIdenticalBases;
    protected OpticalDuplicateFinder opticalDuplicateFinder;

    ElcDuplicatesFinder(double maxDiffRate, int maxReadLength, int minIdenticalBases, OpticalDuplicateFinder opticalDuplicateFinder) {
        this.maxDiffRate = maxDiffRate;
        this.minIdenticalBases = minIdenticalBases;
        this.opticalDuplicateFinder = opticalDuplicateFinder;
        this.maxReadLength = maxReadLength <= 0 ? Integer.MAX_VALUE : maxReadLength;
    }

    abstract void searchDuplicates(List<EstimateLibraryComplexity.PairedReadSequence> var1, Histogram<Integer> var2, Histogram<Integer> var3);

    protected void fillHistogram(Histogram<Integer> duplicationHisto, Histogram<Integer> opticalHisto, EstimateLibraryComplexity.PairedReadSequence prs, List<EstimateLibraryComplexity.PairedReadSequence> dupes) {
        if (!dupes.isEmpty()) {
            boolean[] flags;
            dupes.add(prs);
            int duplicateCount = dupes.size();
            duplicationHisto.increment((Comparable)Integer.valueOf(duplicateCount));
            for (boolean b : flags = this.opticalDuplicateFinder.findOpticalDuplicates(dupes, prs)) {
                if (!b) continue;
                opticalHisto.increment((Comparable)Integer.valueOf(duplicateCount));
            }
        } else {
            duplicationHisto.increment((Comparable)Integer.valueOf(1));
        }
    }

    protected int minLength(byte[] read1, byte[] read2) {
        return Math.min(Math.min(read1.length, read2.length), this.maxReadLength);
    }
}

