/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import picard.PicardException;
import picard.util.GraphUtils;

public class UmiGraph {
    private final List<SAMRecord> records;
    private final Map<String, Long> umiCounts;
    private final int[] duplicateSetID;
    private final String[] umi;
    private final int numUmis;
    private final String umiTag;
    private final String assignedUmiTag;
    private final boolean allowMissingUmis;

    public UmiGraph(DuplicateSet set, String umiTag, String assignedUmiTag, boolean allowMissingUmis) {
        this.umiTag = umiTag;
        this.assignedUmiTag = assignedUmiTag;
        this.allowMissingUmis = allowMissingUmis;
        this.records = set.getRecords();
        for (SAMRecord rec : this.records) {
            if (rec.getStringAttribute(umiTag) != null) continue;
            if (allowMissingUmis) {
                rec.setAttribute(umiTag, (Object)"");
                continue;
            }
            throw new PicardException("Read " + rec.getReadName() + " does not contain a UMI with the " + umiTag + " attribute.");
        }
        this.umiCounts = this.records.stream().collect(Collectors.groupingBy(p -> p.getStringAttribute(umiTag), Collectors.counting()));
        this.numUmis = this.umiCounts.size();
        this.umi = new String[this.numUmis];
        this.duplicateSetID = IntStream.rangeClosed(0, this.numUmis - 1).toArray();
        int i = 0;
        Iterator<String> iterator = this.umiCounts.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            this.umi[i] = key = iterator.next();
            ++i;
        }
    }

    List<DuplicateSet> joinUmisIntoDuplicateSets(int maxEditDistanceToJoin) {
        GraphUtils.Graph<Integer> umiGraph = new GraphUtils.Graph<Integer>();
        for (int i = 0; i < this.numUmis; ++i) {
            umiGraph.addNode(i);
            for (int j = i + 1; j < this.numUmis; ++j) {
                if (!StringUtil.isWithinHammingDistance((String)this.umi[i], (String)this.umi[j], (int)maxEditDistanceToJoin)) continue;
                umiGraph.addEdge(i, j);
            }
        }
        Map umiClusterMap = umiGraph.cluster();
        for (int i = 0; i < this.numUmis; ++i) {
            this.duplicateSetID[i] = umiClusterMap.get(i);
        }
        HashMap duplicateSets = new HashMap();
        Map<String, Integer> duplicateSetsFromUmis = this.getDuplicateSetsFromUmis();
        for (SAMRecord rec : this.records) {
            String umi = rec.getStringAttribute(this.umiTag);
            Integer duplicateSetIndex = duplicateSetsFromUmis.get(umi);
            if (duplicateSets.containsKey(duplicateSetIndex)) {
                ((List)duplicateSets.get(duplicateSetIndex)).add(rec);
                continue;
            }
            ArrayList<SAMRecord> n = new ArrayList<SAMRecord>();
            n.add(rec);
            duplicateSets.put(duplicateSetIndex, n);
        }
        ArrayList<DuplicateSet> duplicateSetList = new ArrayList<DuplicateSet>();
        for (Map.Entry entry : duplicateSets.entrySet()) {
            DuplicateSet ds = new DuplicateSet();
            List recordList = (List)entry.getValue();
            recordList.forEach(arg_0 -> ((DuplicateSet)ds).add(arg_0));
            long maxCount = 0L;
            String assignedUmi = null;
            for (SAMRecord rec : recordList) {
                String umi = rec.getStringAttribute(this.umiTag);
                if (this.umiCounts.get(umi) <= maxCount) continue;
                maxCount = this.umiCounts.get(umi);
                assignedUmi = umi;
            }
            for (SAMRecord rec : recordList) {
                if (this.allowMissingUmis && rec.getStringAttribute(this.umiTag).isEmpty()) {
                    rec.setAttribute(this.umiTag, null);
                    continue;
                }
                rec.setAttribute(this.assignedUmiTag, assignedUmi);
            }
            duplicateSetList.add(ds);
        }
        return duplicateSetList;
    }

    private Map<String, Integer> getDuplicateSetsFromUmis() {
        HashMap<String, Integer> duplicateSetsFromUmis = new HashMap<String, Integer>();
        for (int i = 0; i < this.duplicateSetID.length; ++i) {
            duplicateSetsFromUmis.put(this.umi[i], this.duplicateSetID[i]);
        }
        return duplicateSetsFromUmis;
    }
}

