/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.List;
import picard.sam.util.PhysicalLocation;
import picard.sam.util.ReadNameParser;

public class OpticalDuplicateFinder
extends ReadNameParser {
    public int opticalDuplicatePixelDistance;
    public static final int DEFAULT_OPTICAL_DUPLICATE_DISTANCE = 100;
    public static final int DEFAULT_BIG_DUPLICATE_SET_SIZE = 1000;
    public static final int DEFAULT_MAX_DUPLICATE_SET_SIZE = 300000;
    private int bigDuplicateSetSize = 1000;
    private long maxDuplicateSetSize = 300000L;

    public void setBigDuplicateSetSize(int bigDuplicateSetSize) {
        this.bigDuplicateSetSize = bigDuplicateSetSize;
    }

    public void setMaxDuplicateSetSize(long maxDuplicateSetSize) {
        if (maxDuplicateSetSize < 1L) {
            this.maxDuplicateSetSize = Long.MAX_VALUE;
        }
        this.maxDuplicateSetSize = maxDuplicateSetSize;
    }

    public OpticalDuplicateFinder() {
        this.opticalDuplicatePixelDistance = 100;
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance, Log log) {
        super(readNameRegex, log);
        this.opticalDuplicatePixelDistance = opticalDuplicatePixelDistance;
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance, long maxDuplicateSetSize, Log log) {
        super(readNameRegex, log);
        this.opticalDuplicatePixelDistance = opticalDuplicatePixelDistance;
        this.maxDuplicateSetSize = maxDuplicateSetSize;
    }

    public boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list, PhysicalLocation keeper) {
        int i;
        ProgressLogger progressLoggerForRest;
        ProgressLogger progressLoggerForKeeper;
        Log log;
        boolean logProgress;
        int length = list.size();
        boolean[] opticalDuplicateFlags = new boolean[length];
        if (length < 2 || (long)length > this.maxDuplicateSetSize) {
            return opticalDuplicateFlags;
        }
        int distance = this.opticalDuplicatePixelDistance;
        PhysicalLocation actualKeeper = this.keeperOrNull(list, keeper);
        boolean bl = logProgress = length > this.bigDuplicateSetSize;
        if (logProgress) {
            log = Log.getInstance(OpticalDuplicateFinder.class);
            progressLoggerForKeeper = new ProgressLogger(log, 10000, "compared", "ReadEnds to keeper");
            progressLoggerForRest = new ProgressLogger(log, 1000, "compared", "ReadEnds to others");
            log.info(new Object[]{"Large duplicate set. size = " + length});
            log.debug(new Object[]{"About to compare to keeper:" + actualKeeper});
        } else {
            log = null;
            progressLoggerForKeeper = null;
            progressLoggerForRest = null;
        }
        if (actualKeeper != null) {
            for (i = 0; i < length; ++i) {
                PhysicalLocation other = list.get(i);
                opticalDuplicateFlags[i] = this.closeEnough(actualKeeper, other, distance);
                if (!logProgress) continue;
                progressLoggerForKeeper.record(String.format("%d", other.getReadGroup()), other.getX());
            }
        }
        if (logProgress) {
            log.debug(new Object[]{"Done with comparing to keeper, now the rest."});
        }
        for (i = 0; i < length; ++i) {
            PhysicalLocation lhs = list.get(i);
            if (lhs == actualKeeper) continue;
            if (logProgress) {
                progressLoggerForRest.record(String.format("%d", lhs.getReadGroup()), lhs.getX());
            }
            for (int j = i + 1; j < length; ++j) {
                PhysicalLocation rhs = list.get(j);
                if (rhs == actualKeeper || opticalDuplicateFlags[i] && opticalDuplicateFlags[j] || !this.closeEnough(lhs, rhs, distance)) continue;
                int index = opticalDuplicateFlags[j] ? i : j;
                opticalDuplicateFlags[index] = true;
            }
        }
        return opticalDuplicateFlags;
    }

    private PhysicalLocation keeperOrNull(List<? extends PhysicalLocation> list, PhysicalLocation keeper) {
        if (keeper != null && keeper.hasLocation()) {
            for (PhysicalLocation physicalLocation : list) {
                if (physicalLocation != keeper) continue;
                return keeper;
            }
        }
        return null;
    }

    private boolean closeEnough(PhysicalLocation lhs, PhysicalLocation rhs, int distance) {
        return lhs != rhs && lhs.hasLocation() && rhs.hasLocation() && lhs.getReadGroup() == rhs.getReadGroup() && lhs.getTile() == rhs.getTile() && Math.abs(lhs.getX() - rhs.getX()) <= distance && Math.abs(lhs.getY() - rhs.getY()) <= distance;
    }
}

