/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.List;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CallingMetricAccumulator;

public class GvcfMetricAccumulator
extends CallingMetricAccumulator {
    String sample = null;

    public GvcfMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbsnp) {
        super(dbsnp);
    }

    @Override
    public void setup(VCFHeader vcfHeader) {
        List samples = vcfHeader.getGenotypeSamples();
        if (samples == null || samples.size() != 1) {
            throw new IllegalArgumentException("Expected to have exactly 1 sample in a GVCF, found " + (samples == null ? "0" : Integer.valueOf(samples.size())));
        }
        this.sample = (String)samples.get(0);
    }

    @Override
    public void accumulate(VariantContext vc) {
        VariantContext subContext = vc.subContextFromSample(this.sample);
        super.accumulate(subContext);
    }
}

