/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(summary="Converts a VCF or BCF file to a Picard Interval List.", oneLineSummary="Converts a VCF or BCF file to a Picard Interval List.", programGroup=VcfOrBcf.class)
@DocumentedFeature
public class VcfToIntervalList
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfToIntervalList.class);
    @Argument(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Argument(shortName="O", doc="The output Picard Interval List")
    public File OUTPUT;

    public static void main(String[] argv) {
        new VcfToIntervalList().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervalList = VCFFileReader.fromVcf((File)this.INPUT);
        intervalList.uniqued().write(this.OUTPUT);
        return 0;
    }
}

