/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.DuplicateReadFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.Locus;
import htsjdk.samtools.util.LocusComparator;
import htsjdk.samtools.util.LocusImpl;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ReferenceSequenceMask;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import htsjdk.samtools.util.WholeGenomeReferenceSequenceMask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractLocusIterator<T extends AbstractRecordAndOffset, K extends AbstractLocusInfo<T>>
implements Iterable<K>,
CloseableIterator<K> {
    static final Log LOG = Log.getInstance(AbstractLocusIterator.class);
    private final SamReader samReader;
    private final ReferenceSequenceMask referenceSequenceMask;
    private PeekableIterator<SAMRecord> samIterator;
    private List<SamRecordFilter> samFilters = Arrays.asList(new SecondaryOrSupplementaryFilter(), new DuplicateReadFilter());
    final List<Interval> intervals;
    private final boolean useIndex;
    private final ArrayList<K> complete = new ArrayList(100);
    final ArrayList<K> accumulator = new ArrayList(100);
    private int qualityScoreCutoff = Integer.MIN_VALUE;
    private int mappingQualityScoreCutoff = Integer.MIN_VALUE;
    private boolean includeNonPfReads = true;
    private boolean emitUncoveredLoci = true;
    private int maxReadsToAccumulatePerLocus = Integer.MAX_VALUE;
    private boolean enforcedAccumulationLimit = false;
    protected boolean includeIndels = false;
    private int lastReferenceSequence = 0;
    private int lastPosition = 0;
    private boolean finishedAlignedReads = false;
    private final LocusComparator<Locus> locusComparator = new LocusComparator();
    private int lastInterval = 0;

    public AbstractLocusIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        String className = this.getClass().getSimpleName();
        if (samReader.getFileHeader().getSortOrder() == null || samReader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.unsorted) {
            LOG.warn(className + " constructed with samReader that has SortOrder == unsorted.  ", "Assuming SAM is coordinate sorted, but exceptions may occur if it is not.");
        } else if (samReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException(className + " cannot operate on a SAM file that is not coordinate sorted.");
        }
        this.samReader = samReader;
        this.useIndex = useIndex;
        if (intervalList != null) {
            this.intervals = intervalList.uniqued().getIntervals();
            this.referenceSequenceMask = new IntervalListReferenceSequenceMask(intervalList);
        } else {
            this.intervals = null;
            this.referenceSequenceMask = new WholeGenomeReferenceSequenceMask(samReader.getFileHeader());
        }
    }

    @Override
    public Iterator<K> iterator() {
        if (this.samIterator != null) {
            throw new IllegalStateException("Cannot call iterator() more than once on " + this.getClass().getSimpleName());
        }
        CloseableIterator<SAMRecord> tempIterator = this.intervals != null ? new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(this.samReader, this.intervals, this.useIndex) : this.samReader.iterator();
        if (this.samFilters != null) {
            tempIterator = new FilteringSamIterator(tempIterator, new AggregateFilter(this.samFilters));
        }
        this.samIterator = new PeekableIterator<SAMRecord>(tempIterator);
        return this;
    }

    @Override
    public void close() {
        this.samIterator.close();
    }

    private boolean samHasMore() {
        return !this.finishedAlignedReads && this.samIterator.peek() != null;
    }

    @Override
    public boolean hasNext() {
        if (this.samIterator == null) {
            this.iterator();
        }
        while (this.complete.isEmpty() && (!this.accumulator.isEmpty() || this.samHasMore() || this.hasRemainingMaskBases())) {
            Object locusInfo = this.next();
            if (locusInfo == null) continue;
            this.complete.add(0, locusInfo);
        }
        return !this.complete.isEmpty();
    }

    private boolean hasRemainingMaskBases() {
        if (!this.emitUncoveredLoci) {
            return false;
        }
        return this.lastReferenceSequence < this.referenceSequenceMask.getMaxSequenceIndex() || this.lastReferenceSequence == this.referenceSequenceMask.getMaxSequenceIndex() && this.lastPosition < this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
    }

    @Override
    public K next() {
        while (this.complete.isEmpty() && this.samHasMore()) {
            SAMRecord rec = this.samIterator.peek();
            if (rec.getReferenceIndex() == -1) {
                this.finishedAlignedReads = true;
                continue;
            }
            if (rec.getReadUnmappedFlag() || rec.getMappingQuality() < this.mappingQualityScoreCutoff || !this.includeNonPfReads && rec.getReadFailsVendorQualityCheckFlag()) {
                this.samIterator.next();
                continue;
            }
            int start = rec.getAlignmentStart();
            if (this.includeIndels && start != 1 && AbstractLocusIterator.startWithInsertion(rec.getCigar())) {
                --start;
            }
            LocusImpl alignmentStart = new LocusImpl(rec.getReferenceIndex(), start);
            while (!this.accumulator.isEmpty() && this.locusComparator.compare((Locus)this.accumulator.get(0), alignmentStart) < 0) {
                AbstractLocusInfo first = (AbstractLocusInfo)this.accumulator.get(0);
                this.populateCompleteQueue(alignmentStart);
                if (!this.complete.isEmpty()) {
                    return (K)((AbstractLocusInfo)this.complete.remove(0));
                }
                if (this.accumulator.isEmpty() || first != this.accumulator.get(0)) continue;
                throw new SAMException("Stuck in infinite loop");
            }
            if (!(this.accumulator.isEmpty() || ((AbstractLocusInfo)this.accumulator.get(0)).getSequenceIndex() == rec.getReferenceIndex().intValue() && ((AbstractLocusInfo)this.accumulator.get(0)).getPosition() == start)) {
                throw new IllegalStateException("accumulator should be empty or aligned with current SAMRecord");
            }
            if (!this.surpassedAccumulationThreshold()) {
                this.accumulateSamRecord(rec);
                if (this.includeIndels) {
                    this.accumulateIndels(rec);
                }
            }
            this.samIterator.next();
        }
        LocusImpl endLocus = new LocusImpl(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.complete.isEmpty() && !this.samHasMore()) {
            while (!this.accumulator.isEmpty()) {
                this.populateCompleteQueue(endLocus);
                if (this.complete.isEmpty()) continue;
                return (K)((AbstractLocusInfo)this.complete.remove(0));
            }
        }
        if (!this.complete.isEmpty()) {
            return (K)((AbstractLocusInfo)this.complete.remove(0));
        }
        if (this.emitUncoveredLoci) {
            LocusImpl afterLastMaskPositionLocus = new LocusImpl(this.referenceSequenceMask.getMaxSequenceIndex(), this.referenceSequenceMask.getMaxPosition() + 1);
            return this.createNextUncoveredLocusInfo(afterLastMaskPositionLocus);
        }
        return null;
    }

    private boolean surpassedAccumulationThreshold() {
        boolean surpassesThreshold;
        boolean bl = surpassesThreshold = !this.accumulator.isEmpty() && ((AbstractLocusInfo)this.accumulator.get(0)).getRecordAndOffsets().size() >= this.maxReadsToAccumulatePerLocus;
        if (surpassesThreshold && !this.enforcedAccumulationLimit) {
            LOG.warn("We have encountered greater than " + this.maxReadsToAccumulatePerLocus + " reads at position " + ((AbstractLocusInfo)this.accumulator.get(0)).toString() + " and will ignore the remaining reads at this position.  Note that further warnings will be suppressed.");
            this.enforcedAccumulationLimit = true;
        }
        return surpassesThreshold;
    }

    abstract void accumulateSamRecord(SAMRecord var1);

    abstract void accumulateIndels(SAMRecord var1);

    abstract T createRecordAndOffset(SAMRecord var1, int var2, int var3, int var4);

    private K createNextUncoveredLocusInfo(Locus stopBeforeLocus) {
        while (this.lastReferenceSequence <= stopBeforeLocus.getSequenceIndex() && this.lastReferenceSequence <= this.referenceSequenceMask.getMaxSequenceIndex()) {
            if (this.lastReferenceSequence == stopBeforeLocus.getSequenceIndex() && this.lastPosition + 1 >= stopBeforeLocus.getPosition()) {
                return null;
            }
            int nextbit = this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
            if (nextbit == -1) {
                if (this.lastReferenceSequence == stopBeforeLocus.getSequenceIndex()) {
                    this.lastPosition = stopBeforeLocus.getPosition();
                    return null;
                }
                ++this.lastReferenceSequence;
                this.lastPosition = 0;
                continue;
            }
            if (this.lastReferenceSequence < stopBeforeLocus.getSequenceIndex() || nextbit < stopBeforeLocus.getPosition()) {
                this.lastPosition = nextbit;
                return this.createLocusInfo(this.getReferenceSequence(this.lastReferenceSequence), this.lastPosition);
            }
            if (nextbit < stopBeforeLocus.getPosition()) continue;
            return null;
        }
        return null;
    }

    abstract K createLocusInfo(SAMSequenceRecord var1, int var2);

    private void populateCompleteQueue(Locus stopBeforeLocus) {
        K zeroCoverage;
        this.removeSkippedRegion(stopBeforeLocus);
        if (this.accumulator.isEmpty()) {
            return;
        }
        AbstractLocusInfo locusInfo = (AbstractLocusInfo)this.accumulator.get(0);
        if (this.locusComparator.compare(stopBeforeLocus, locusInfo) <= 0) {
            return;
        }
        if (this.emitUncoveredLoci && (zeroCoverage = this.createNextUncoveredLocusInfo(locusInfo)) != null) {
            this.complete.add(zeroCoverage);
            return;
        }
        this.accumulator.remove(0);
        int sequenceIndex = locusInfo.getSequenceIndex();
        if (this.referenceSequenceMask.get(locusInfo.getSequenceIndex(), locusInfo.getPosition())) {
            this.complete.add(locusInfo);
        }
        this.lastReferenceSequence = sequenceIndex;
        this.lastPosition = locusInfo.getPosition();
    }

    private void removeSkippedRegion(Locus stopBeforeLocus) {
        int i;
        for (i = 0; i < this.accumulator.size() && ((AbstractLocusInfo)this.accumulator.get(i)).isEmpty() && this.locusComparator.compare((Locus)this.accumulator.get(i), stopBeforeLocus) < 0; ++i) {
        }
        if (i > 0) {
            this.accumulator.subList(0, i).clear();
        }
    }

    protected SAMSequenceRecord getReferenceSequence(int referenceSequenceIndex) {
        return this.samReader.getFileHeader().getSequence(referenceSequenceIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    protected static boolean startWithInsertion(Cigar cigar) {
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() == CigarOperator.I) {
                return true;
            }
            if (!element.getOperator().consumesReferenceBases()) continue;
        }
        return false;
    }

    public void setSamFilters(List<SamRecordFilter> samFilters) {
        this.samFilters = samFilters;
    }

    public int getQualityScoreCutoff() {
        return this.qualityScoreCutoff;
    }

    public void setQualityScoreCutoff(int qualityScoreCutoff) {
        this.qualityScoreCutoff = qualityScoreCutoff;
    }

    public int getMappingQualityScoreCutoff() {
        return this.mappingQualityScoreCutoff;
    }

    public void setMappingQualityScoreCutoff(int mappingQualityScoreCutoff) {
        this.mappingQualityScoreCutoff = mappingQualityScoreCutoff;
    }

    public boolean isIncludeNonPfReads() {
        return this.includeNonPfReads;
    }

    public void setIncludeNonPfReads(boolean includeNonPfReads) {
        this.includeNonPfReads = includeNonPfReads;
    }

    public boolean isEmitUncoveredLoci() {
        return this.emitUncoveredLoci;
    }

    public void setEmitUncoveredLoci(boolean emitUncoveredLoci) {
        this.emitUncoveredLoci = emitUncoveredLoci;
    }

    public int getMaxReadsToAccumulatePerLocus() {
        return this.maxReadsToAccumulatePerLocus;
    }

    public void setMaxReadsToAccumulatePerLocus(int maxReadsToAccumulatePerLocus) {
        this.maxReadsToAccumulatePerLocus = maxReadsToAccumulatePerLocus;
    }

    protected List<Interval> getIntervals() {
        return this.intervals;
    }

    protected Interval getCurrentInterval() {
        if (this.intervals == null) {
            return null;
        }
        return this.intervals.get(this.lastInterval);
    }

    public boolean isIncludeIndels() {
        return this.includeIndels;
    }

    public void setIncludeIndels(boolean includeIndels) {
        this.includeIndels = includeIndels;
    }
}

