/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BWAMapperProvider
extends AbstractMapperProvider {
    public static final String MAPPER_NAME = "BWA";
    private static final String DEFAULT_VERSION = "0.6.2";
    private static final String MAPPER_EXECUTABLE = "bwa";
    private static final String INDEXER_EXECUTABLE = "bwa";
    private static final String MEM_FLAVOR = "mem";
    private static final String ALN_FLAVOR = "aln";
    private static final int MIN_BWTSW_GENOME_SIZE = 0x40000000;
    public static final String DEFAULT_ARGUMENTS = "-l 28";
    private static final String SYNC = BWAMapperProvider.class.getName();
    private static final String PREFIX_FILES = "bwa";
    private static final String SAI_EXTENSION = ".sai";
    private static final String FASTQ_EXTENSION = ".fq";

    @Override
    public String getName() {
        return MAPPER_NAME;
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    public String getDefaultFlavor() {
        return ALN_FLAVOR;
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readBinaryVersion(MapperInstance mapperInstance) {
        try {
            String[] lines;
            String execPath;
            String string = SYNC;
            synchronized (string) {
                execPath = mapperInstance.getExecutor().install("bwa");
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{execPath});
            String s = MapperUtils.executeToString(mapperInstance.getExecutor(), cmd);
            for (String line : lines = s.split("\n")) {
                String[] tokens;
                if (!line.startsWith("Version:") || (tokens = line.split(":")).length <= 1) continue;
                return tokens[1].trim();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Collections.singletonList("bwa");
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return "bwa";
    }

    @Override
    public boolean checkIfFlavorExists(MapperInstance mapperInstance) {
        switch (mapperInstance.getFlavor().trim().toLowerCase()) {
            case "aln": 
            case "mem": {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getIndexerCommand(File indexerFile, File genomeFile, List<String> indexerArguments, int threads) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (genomeFile.length() >= 0x40000000L) {
            cmd.add("index");
            cmd.add("-a");
            cmd.add("bwtsw");
            cmd.add(genomeFile.getAbsolutePath());
            return cmd;
        }
        cmd.add(indexerFile.getAbsolutePath());
        cmd.add("index");
        cmd.add(genomeFile.getAbsolutePath());
        return cmd;
    }

    private String getIndexPath(File archiveIndexDir) throws IOException {
        return MapperUtils.getIndexPath(this.getName(), archiveIndexDir, ".bwt", 4).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapSE(EntryMapping mapping, File inputFile, File errorFile, File logFile) throws IOException {
        String bwaPath;
        String string = SYNC;
        synchronized (string) {
            bwaPath = mapping.getExecutor().install("bwa");
        }
        String indexPath = this.getIndexPath(mapping.getIndexDirectory());
        return this.createMapperProcessSE(mapping, bwaPath, indexPath, inputFile, errorFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapPE(EntryMapping mapping, File inputFile1, File inputFile2, File errorFile, File logFile) throws IOException {
        String bwaPath;
        String string = SYNC;
        synchronized (string) {
            bwaPath = mapping.getExecutor().install("bwa");
        }
        String indexPath = this.getIndexPath(mapping.getIndexDirectory());
        return this.createMapperProcessPE(mapping, bwaPath, indexPath, inputFile1, inputFile2, errorFile);
    }

    private MapperProcess createMapperProcessSE(final EntryMapping mapping, final String bwaPath, final String indexPath, final File inputFile, File errorFile) throws IOException {
        boolean bwaAln;
        boolean bl = bwaAln = !MEM_FLAVOR.equals(mapping.getFlavor());
        if (bwaAln) {
            return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){
                private File saiFile;
                private File fastqFile;
                private MapperProcess.FastqWriterThread writer;

                @Override
                protected void additionalInit() throws IOException {
                    File tmpDir = mapping.getTemporaryDirectory();
                    String uuid = this.getUUID();
                    this.saiFile = new File(tmpDir, "bwa-sai-" + uuid + BWAMapperProvider.SAI_EXTENSION);
                    FileUtils.createNamedPipe((File)this.saiFile);
                    if (inputFile == null) {
                        this.fastqFile = new File(tmpDir, "bwa-fastq-" + uuid + BWAMapperProvider.FASTQ_EXTENSION);
                        this.writer = new MapperProcess.FastqWriterThread(this.fastqFile, "BWA samse writeFirstPairEntries thread");
                    }
                    this.addFilesToRemove(this.saiFile, this.fastqFile);
                }

                @Override
                public void writeEntry(String name, String sequence, String quality) throws IOException {
                    super.writeEntry(name, sequence, quality);
                    this.writer.write(ReadSequence.toFastQ((String)name, (String)sequence, (String)quality) + '\n');
                }

                @Override
                public void writeEntry1(ReadSequence read) throws IOException {
                    super.writeEntry1(read);
                    this.writer.write(read.toFastQ() + '\n');
                }

                @Override
                public void closeEntriesWriter() throws IOException {
                    super.closeWriter1();
                    this.writer.close();
                }

                @Override
                public void closeWriter1() throws IOException {
                    super.closeWriter1();
                    this.writer.close();
                }

                @Override
                protected List<List<String>> createCommandLines() {
                    boolean illuminaFastq = mapping.getFastqFormat() == FastqFormat.FASTQ_ILLUMINA || mapping.getFastqFormat() == FastqFormat.FASTQ_ILLUMINA_1_5;
                    ArrayList<String> cmd1 = new ArrayList<String>();
                    cmd1.add(bwaPath);
                    cmd1.add(BWAMapperProvider.ALN_FLAVOR);
                    if (illuminaFastq) {
                        cmd1.add("-I");
                    }
                    cmd1.addAll(mapping.getMapperArguments());
                    cmd1.add("-t");
                    cmd1.add(mapping.getThreadNumber() + "");
                    cmd1.add("-f");
                    cmd1.add(this.saiFile.getAbsolutePath());
                    cmd1.add(indexPath);
                    cmd1.add(this.getNamedPipeFile1().getAbsolutePath());
                    ArrayList<String> cmd2 = new ArrayList<String>();
                    cmd2.add(bwaPath);
                    cmd2.add("samse");
                    cmd2.add(indexPath);
                    cmd2.add(this.saiFile.getAbsolutePath());
                    if (inputFile != null) {
                        cmd2.add(inputFile.getAbsolutePath());
                    } else {
                        cmd2.add(this.fastqFile.getAbsolutePath());
                    }
                    ArrayList<List<String>> result = new ArrayList<List<String>>();
                    result.add(cmd1);
                    result.add(cmd2);
                    return result;
                }
            };
        }
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(bwaPath);
                cmd.add(BWAMapperProvider.MEM_FLAVOR);
                cmd.addAll(mapping.getMapperArguments());
                cmd.add("-t");
                cmd.add(mapping.getThreadNumber() + "");
                cmd.add(indexPath);
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }

    private MapperProcess createMapperProcessPE(final EntryMapping mapping, final String bwaPath, final String indexPath, final File inputFile1, final File inputFile2, File errorFile) throws IOException {
        boolean bwaAln;
        boolean bl = bwaAln = !MEM_FLAVOR.equals(mapping.getFlavor());
        if (bwaAln) {
            return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, true, inputFile1, inputFile2){
                private File saiFile1;
                private File saiFile2;
                private File fastqFile1;
                private File fastqFile2;
                private MapperProcess.FastqWriterThread writer1;
                private MapperProcess.FastqWriterThread writer2;

                @Override
                protected void additionalInit() throws IOException {
                    File tmpDir = mapping.getTemporaryDirectory();
                    String uuid = this.getUUID();
                    this.saiFile1 = new File(tmpDir, "bwa-sai1-" + uuid + BWAMapperProvider.SAI_EXTENSION);
                    this.saiFile2 = new File(tmpDir, "bwa-sai2-" + uuid + BWAMapperProvider.SAI_EXTENSION);
                    if (inputFile1 == null) {
                        this.fastqFile1 = new File(tmpDir, "bwa-fastq1-" + uuid + BWAMapperProvider.FASTQ_EXTENSION);
                        this.fastqFile2 = new File(tmpDir, "bwa-fastq2-" + uuid + BWAMapperProvider.FASTQ_EXTENSION);
                        this.writer1 = new MapperProcess.FastqWriterThread(this.fastqFile1, "BWA sampe writeFirstPairEntries thread");
                        this.writer2 = new MapperProcess.FastqWriterThread(this.fastqFile2, "BWA sampe writeSecondPairEntries thread");
                    }
                    FileUtils.createNamedPipe((File)this.saiFile1);
                    FileUtils.createNamedPipe((File)this.saiFile2);
                    this.addFilesToRemove(this.saiFile1, this.saiFile2, this.fastqFile1, this.fastqFile2);
                }

                @Override
                public void writeEntry(String name1, String sequence1, String quality1, String name2, String sequence2, String quality2) throws IOException {
                    super.writeEntry(name1, sequence1, quality1, name2, sequence2, quality2);
                    this.writer1.write(ReadSequence.toFastQ((String)name1, (String)sequence1, (String)quality2) + '\n');
                    this.writer2.write(ReadSequence.toFastQ((String)name2, (String)sequence2, (String)quality2) + '\n');
                }

                @Override
                public void writeEntry1(ReadSequence read) throws IOException {
                    super.writeEntry1(read);
                    this.writer1.write(read.toFastQ() + '\n');
                }

                @Override
                public void writeEntry2(ReadSequence read) throws IOException {
                    super.writeEntry2(read);
                    this.writer2.write(read.toFastQ() + '\n');
                }

                @Override
                public void closeEntriesWriter() throws IOException {
                    super.closeWriter1();
                    super.closeWriter2();
                    this.writer1.close();
                    this.writer2.close();
                }

                @Override
                public void closeWriter1() throws IOException {
                    super.closeWriter1();
                    this.writer1.close();
                }

                @Override
                public void closeWriter2() throws IOException {
                    super.closeWriter2();
                    this.writer2.close();
                }

                @Override
                protected List<List<String>> createCommandLines() {
                    boolean illuminaFastq = mapping.getFastqFormat() == FastqFormat.FASTQ_ILLUMINA || mapping.getFastqFormat() == FastqFormat.FASTQ_ILLUMINA_1_5;
                    ArrayList<String> cmd1 = new ArrayList<String>();
                    cmd1.add(bwaPath);
                    if (BWAMapperProvider.MEM_FLAVOR.equals(mapping.getFlavor())) {
                        cmd1.add(BWAMapperProvider.MEM_FLAVOR);
                    } else {
                        cmd1.add(BWAMapperProvider.ALN_FLAVOR);
                    }
                    if (illuminaFastq) {
                        cmd1.add("-I");
                    }
                    int threadNumber = mapping.getThreadNumber() > 1 ? mapping.getThreadNumber() / 2 : 1;
                    cmd1.addAll(mapping.getMapperArguments());
                    cmd1.add("-t");
                    cmd1.add(threadNumber + "");
                    cmd1.add("-f");
                    cmd1.add(this.saiFile1.getAbsolutePath());
                    cmd1.add(indexPath);
                    cmd1.add(this.getNamedPipeFile1().getAbsolutePath());
                    ArrayList<String> cmd2 = new ArrayList<String>();
                    cmd2.add(bwaPath);
                    cmd2.add(BWAMapperProvider.ALN_FLAVOR);
                    if (illuminaFastq) {
                        cmd2.add("-I");
                    }
                    cmd2.addAll(mapping.getMapperArguments());
                    cmd2.add("-t");
                    cmd2.add(threadNumber + "");
                    cmd2.add("-f");
                    cmd2.add(this.saiFile2.getAbsolutePath());
                    cmd2.add(indexPath);
                    cmd2.add(this.getNamedPipeFile2().getAbsolutePath());
                    ArrayList<String> cmd3 = new ArrayList<String>();
                    cmd3.add(bwaPath);
                    cmd3.add("sampe");
                    cmd3.add(indexPath);
                    cmd3.add(this.saiFile1.getAbsolutePath());
                    cmd3.add(this.saiFile2.getAbsolutePath());
                    if (inputFile1 != null) {
                        cmd3.add(inputFile1.getAbsolutePath());
                        cmd3.add(inputFile2.getAbsolutePath());
                    } else {
                        cmd3.add(this.fastqFile1.getAbsolutePath());
                        cmd3.add(this.fastqFile2.getAbsolutePath());
                    }
                    ArrayList<List<String>> result = new ArrayList<List<String>>();
                    result.add(cmd1);
                    result.add(cmd2);
                    result.add(cmd3);
                    return result;
                }
            };
        }
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, true, inputFile1, inputFile2){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(bwaPath);
                cmd.add(BWAMapperProvider.MEM_FLAVOR);
                cmd.addAll(mapping.getMapperArguments());
                cmd.add("-t");
                cmd.add(mapping.getThreadNumber() + "");
                cmd.add(indexPath);
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                cmd.add(this.getNamedPipeFile2().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }
}

