/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.BinariesInstaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.Objects;

public class BundledMapperExecutor
implements MapperExecutor {
    private final BinariesInstaller installer;
    private final String softwarePackage;
    private final String version;
    private final File executablesTemporaryDirectory;
    private final GenericLogger logger;

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public String install(String executable) throws IOException {
        String result;
        FileLock lock2;
        Throwable throwable;
        FileChannel channel;
        Objects.requireNonNull(executable, "executable argument cannot be null");
        if (!this.executablesTemporaryDirectory.isDirectory()) {
            throw new IOException("The temporary directory for executables does not exists or is not a directory: " + this.executablesTemporaryDirectory.getAbsolutePath());
        }
        File lockFile = new File(this.executablesTemporaryDirectory, executable + ".lock");
        try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");){
            channel = raf.getChannel();
            throwable = null;
            try {
                lock2 = channel.lock();
                result = this.installer.install(this.softwarePackage, this.version, executable, this.executablesTemporaryDirectory.getAbsolutePath());
                lock2.release();
            }
            catch (Throwable lock2) {
                throwable = lock2;
                throw lock2;
            }
            finally {
                if (channel != null) {
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable lock2) {
                            throwable.addSuppressed(lock2);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
        raf = new RandomAccessFile(lockFile, "rw");
        var5_4 = null;
        try {
            channel = raf.getChannel();
            throwable = null;
            try {
                lock2 = channel.tryLock();
                if (lock2 != null) {
                    lockFile.delete();
                    lock2.release();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (channel != null) {
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var5_4 = throwable4;
            throw throwable4;
        }
        finally {
            if (raf != null) {
                if (var5_4 != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable5) {
                        var5_4.addSuppressed(throwable5);
                    }
                } else {
                    raf.close();
                }
            }
        }
        return result;
    }

    @Override
    public boolean isExecutable(String executable) {
        Objects.requireNonNull(executable, "executable argument cannot be null");
        return this.installer.check(this.softwarePackage, this.version, executable);
    }

    @Override
    public MapperExecutor.Result execute(List<String> command, File executionDirectory, boolean stdout, File stdErrFile, boolean redirectStderr, File ... fileUsed) throws IOException {
        Objects.requireNonNull(command, "command argument cannot be null");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(redirectStderr);
        if (stdErrFile != null) {
            builder.redirectError(stdErrFile);
        } else if (!redirectStderr) {
            builder.redirectError(new File("/dev/null"));
        }
        if (executionDirectory != null) {
            builder.directory(executionDirectory);
        }
        this.logger.info("Process command: " + Joiner.on((char)' ').join(builder.command()));
        this.logger.info("Process directory: " + builder.directory());
        this.logger.debug("Process redirect output: " + builder.redirectOutput());
        this.logger.debug("Process redirect error: " + builder.redirectError());
        return new ProcessResult(builder.start());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("softwarePackage", (Object)this.softwarePackage).add("version", (Object)this.version).add("executablesTemporaryDirectory", (Object)this.executablesTemporaryDirectory).toString();
    }

    BundledMapperExecutor(String softwarePackage, String version, File executablesTemporaryDirectory, GenericLogger logger, String applicationName, String applicationVersion) {
        Objects.requireNonNull(softwarePackage, "dockerConnection argument cannot be null");
        Objects.requireNonNull(version, "version argument cannot be null");
        Objects.requireNonNull(executablesTemporaryDirectory, "dockerConnection argument cannot be null");
        Objects.requireNonNull(logger, "logger argument cannot be null");
        Objects.requireNonNull(applicationName, "applicationName argument cannot be null");
        Objects.requireNonNull(applicationVersion, "applicationName argument cannot be null");
        this.installer = new BinariesInstaller(applicationName, applicationVersion, logger);
        this.softwarePackage = softwarePackage;
        this.version = version;
        this.executablesTemporaryDirectory = executablesTemporaryDirectory;
        this.logger = logger;
    }

    static class ProcessResult
    implements MapperExecutor.Result {
        private final Process process;

        @Override
        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        @Override
        public int waitFor() throws IOException {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        ProcessResult(Process process) {
            Objects.requireNonNull(process, "process argument cannot be null");
            this.process = process;
        }
    }
}

