/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import fr.ens.biologie.genomique.kenetre.util.process.DockerManager;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class DockerMapperExecutor
implements MapperExecutor {
    private final DockerImageInstance dockerConnection;
    private final File temporaryDirectory;
    private final GenericLogger logger;

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isExecutable(String executable) throws IOException {
        Objects.requireNonNull(executable, "binaryFilename argument cannot be null");
        Preconditions.checkArgument((!executable.isEmpty() ? 1 : 0) != 0, (Object)"binaryFilename argument cannot be empty");
        ArrayList command = Lists.newArrayList((Object[])new String[]{"which", executable});
        MapperExecutor.Result result = this.execute(command, null, false, null, false, null);
        return result.waitFor() == 0;
    }

    @Override
    public String install(String executable) throws IOException {
        Objects.requireNonNull(executable, "executable argument cannot be null");
        return executable;
    }

    @Override
    public MapperExecutor.Result execute(List<String> command, File executionDirectory, boolean stdout, File stdErrFile, boolean redirectStderr, File ... filesUsed) throws IOException {
        Objects.requireNonNull(command, "executable argument cannot be null");
        return new DockerResult((List)command, executionDirectory, stdout, stdErrFile, redirectStderr, filesUsed);
    }

    private List<String> convertCommand(List<String> command, File stdout, boolean redirectStderr) {
        Objects.requireNonNull(command, "command argument cannot be null");
        if (stdout == null) {
            return command;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("sh");
        result.add("-c");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String c : command) {
            if (first) {
                sb.append(' ');
            }
            sb.append(StringUtils.bashEscaping((String)c));
        }
        sb.append(redirectStderr ? " &> " : " > ");
        sb.append(stdout.getAbsolutePath());
        result.add(sb.toString());
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dockerConnection", (Object)this.dockerConnection).add("temporaryDirectory", (Object)this.temporaryDirectory).toString();
    }

    DockerMapperExecutor(String dockerImage, File temporaryDirectory, GenericLogger logger) throws IOException {
        Objects.requireNonNull(dockerImage, "dockerImage argument cannot be null");
        Objects.requireNonNull(temporaryDirectory, "temporaryDirectory argument cannot be null");
        Objects.requireNonNull(logger, "logger argument cannot be null");
        this.temporaryDirectory = temporaryDirectory;
        this.dockerConnection = DockerManager.getInstance().createImageInstance(dockerImage);
        this.logger = logger;
    }

    private class DockerResult
    implements MapperExecutor.Result {
        private final File stdoutFile;
        private Integer waitForResult;
        private SimpleProcess.AdvancedProcess process;

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.stdoutFile == null) {
                throw new IOException("The excution command has not been configured to redirect stdout");
            }
            try {
                FileInputStream fis = new FileInputStream(this.stdoutFile);
                return Channels.newInputStream(fis.getChannel());
            }
            catch (FileNotFoundException e) {
                DockerMapperExecutor.this.logger.error("Cannot find stdout named pipe of the container: " + this.stdoutFile);
                return null;
            }
        }

        @Override
        public int waitFor() throws IOException {
            if (this.waitForResult != null) {
                return this.waitForResult;
            }
            DockerMapperExecutor.this.logger.debug("Wait the end of the Docker container");
            int result = this.process.waitFor();
            if (this.stdoutFile != null && !this.stdoutFile.delete()) {
                DockerMapperExecutor.this.logger.warn("Unable to delete stdout file: " + this.stdoutFile);
            }
            this.waitForResult = result;
            return result;
        }

        private DockerResult(List<String> command, File executionDirectory, boolean stdout, File stdErrFile, boolean redirectStderr, File ... filesUsed) throws IOException {
            Objects.requireNonNull(command, "command argument cannot be null");
            DockerMapperExecutor.this.dockerConnection.pullImageIfNotExists();
            DockerMapperExecutor.this.logger.debug("Configure container, command to execute: " + command);
            ArrayList<File> newFilesUsed = new ArrayList<File>();
            if (filesUsed != null) {
                Collections.addAll(newFilesUsed, filesUsed);
            }
            if (stdout) {
                String uuid = UUID.randomUUID().toString();
                this.stdoutFile = new File(DockerMapperExecutor.this.temporaryDirectory, "stdout-" + uuid);
                FileUtils.createNamedPipe((File)this.stdoutFile);
                newFilesUsed.add(this.stdoutFile);
            } else {
                this.stdoutFile = null;
            }
            if (stdErrFile != null) {
                newFilesUsed.add(stdErrFile);
            }
            DockerMapperExecutor.this.logger.debug("Start of the Docker container");
            File nullFile = new File("/dev/null");
            File finalErrFile = stdErrFile == null ? nullFile : stdErrFile;
            File[] files = newFilesUsed.toArray(new File[0]);
            this.process = DockerMapperExecutor.this.dockerConnection.start(DockerMapperExecutor.this.convertCommand(command, this.stdoutFile, redirectStderr), executionDirectory, null, null, nullFile, finalErrFile, false, files);
        }
    }
}

