/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperIndex;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProvider;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class EntryMapping {
    protected final MapperIndex mapperIndex;
    protected final FastqFormat fastqFormat;
    protected final ReporterIncrementer incrementer;
    protected final String counterGroup;
    protected final List<String> mapperArguments;
    protected final int threadNumber;
    protected final boolean multipleInstanceEnabled;
    protected final GenericLogger logger;

    public FastqFormat getFastqFormat() {
        return this.fastqFormat;
    }

    public List<String> getMapperArguments() {
        return this.mapperArguments;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public boolean isMultipleInstancesEnabled() {
        return this.multipleInstanceEnabled;
    }

    public String getName() {
        return this.mapperIndex.getMapperInstance().getMapper().getName();
    }

    public String getVersion() {
        return this.mapperIndex.getMapperInstance().getVersion();
    }

    public String getFlavor() {
        return this.mapperIndex.getMapperInstance().getFlavor();
    }

    public File getTemporaryDirectory() {
        return this.mapperIndex.getMapperInstance().getTemporaryDirectory();
    }

    public MapperExecutor getExecutor() {
        return this.mapperIndex.getMapperInstance().getExecutor();
    }

    public File getIndexDirectory() {
        return this.mapperIndex.getIndexDirectory();
    }

    protected MapperProvider getProvider() {
        return this.mapperIndex.getMapperInstance().getMapper().getProvider();
    }

    public MapperInstance getMapperInstance() {
        return this.mapperIndex.getMapperInstance();
    }

    public MapperProcess mapSE() throws IOException {
        return this.mapSE(null, null);
    }

    public MapperProcess mapSE(File errorFile, File logFile) throws IOException {
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in single-end mode");
        MapperProcess result = this.getProvider().mapSE(this, null, errorFile, logFile);
        result.setIncrementer(this.incrementer, this.counterGroup);
        result.startProcess();
        return result;
    }

    public MapperProcess mapPE() throws IOException {
        return this.mapPE(null, null);
    }

    public MapperProcess mapPE(File errorFile, File logFile) throws IOException {
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in paired-end mode");
        MapperProcess result = this.getProvider().mapPE(this, null, null, errorFile, logFile);
        result.setIncrementer(this.incrementer, this.counterGroup);
        result.startProcess();
        return result;
    }

    EntryMapping(MapperIndex mapperIndex, FastqFormat fastqFormat, List<String> mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup, GenericLogger logger) {
        Objects.requireNonNull(mapperIndex, "mapperIndex cannot be null");
        Objects.requireNonNull(fastqFormat, "fastqFormat cannot be null");
        Objects.requireNonNull(mapperArguments, "mapperArguments cannot be null");
        this.mapperIndex = mapperIndex;
        this.fastqFormat = fastqFormat;
        this.mapperArguments = mapperArguments;
        this.multipleInstanceEnabled = mapperIndex.getMapperInstance().getMapper().getProvider().isMultipleInstancesAllowed() && multipleInstanceEnabled;
        this.threadNumber = threadNumber > 1 && !this.multipleInstanceEnabled ? threadNumber : 1;
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
        this.logger = logger;
    }
}

