/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperIndex;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class FileMapping
extends EntryMapping {
    private IOException mappingException;

    public void throwMappingException() throws IOException {
        if (this.mappingException != null) {
            throw this.mappingException;
        }
    }

    public final MapperProcess mapPE(File readsFile1, File readsFile2, File errorFile, File logFile) throws IOException {
        Objects.requireNonNull(readsFile1, "readsFile1 is null");
        Objects.requireNonNull(readsFile2, "readsFile2 is null");
        FileUtils.checkExistingStandardFile((File)readsFile1, (String)"readsFile1 not exits or is not a standard file.");
        FileUtils.checkExistingStandardFile((File)readsFile2, (String)"readsFile2 not exits or is not a standard file.");
        this.logger.debug("First pair FASTQ file to map: " + readsFile1);
        this.logger.debug("Second pair FASTQ file to map: " + readsFile2);
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in paired-end mode");
        MapperProcess result = this.getProvider().mapPE(this, readsFile1, readsFile2, errorFile, logFile);
        result.setIncrementer(this.incrementer, this.counterGroup);
        result.startProcess();
        return result;
    }

    public MapperProcess mapPE(InputStream in1, InputStream in2, File errorFile, File logFile) throws IOException {
        Objects.requireNonNull(in1, "in1 argument is null");
        Objects.requireNonNull(in2, "in2 argument is null");
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in paired-end mode");
        Objects.requireNonNull(in1, "readsFile1 is null");
        Objects.requireNonNull(in2, "readsFile2 is null");
        MapperProcess mapperProcess = super.mapPE(errorFile, logFile);
        this.writeFirstPairEntries(in1, mapperProcess);
        this.writeSecondPairEntries(in2, mapperProcess);
        return mapperProcess;
    }

    public MapperProcess mapSE(InputStream in, File errorFile, File logFile) throws IOException {
        Objects.requireNonNull(in, "in argument is null");
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in single-end mode");
        MapperProcess mapperProcess = super.mapSE(errorFile, logFile);
        this.writeFirstPairEntries(in, mapperProcess);
        return mapperProcess;
    }

    public MapperProcess mapSE(File readsFile, File errorFile, File logFile) throws IOException {
        Objects.requireNonNull(readsFile, "readsFile is null");
        FileUtils.checkExistingStandardFile((File)readsFile, (String)"reads File not exits or is not a standard file.");
        this.logger.debug("FASTQ file to map: " + readsFile);
        this.logger.debug("Mapping with " + this.mapperIndex.getMapperName() + " in single-end mode");
        MapperProcess result = this.getProvider().mapSE(this, readsFile, errorFile, logFile);
        result.setIncrementer(this.incrementer, this.counterGroup);
        result.startProcess();
        return result;
    }

    private void writeFirstPairEntries(InputStream in, MapperProcess mp) throws FileNotFoundException {
        Objects.requireNonNull(in, "in argument cannot be null");
        Objects.requireNonNull(mp, "mp argument cannot be null");
        Thread t = new Thread(() -> {
            try {
                FastqReader reader = new FastqReader(in);
                for (ReadSequence read : reader) {
                    mp.writeEntry1(read);
                }
                reader.close();
                mp.closeWriter1();
            }
            catch (IOException e) {
                this.mappingException = e;
            }
        }, "Mapper writeFirstPairEntries thread");
        t.start();
    }

    private void writeSecondPairEntries(InputStream in, MapperProcess mp) throws FileNotFoundException {
        Objects.requireNonNull(in, "in argument cannot be null");
        Objects.requireNonNull(mp, "mp argument cannot be null");
        Thread t = new Thread(() -> {
            try {
                FastqReader reader = new FastqReader(in);
                for (ReadSequence read : reader) {
                    mp.writeEntry2(read);
                }
                reader.close();
                mp.closeWriter2();
            }
            catch (IOException e) {
                this.mappingException = e;
            }
        }, "Mapper writeSecondPairEntries thread");
        t.start();
    }

    @Override
    public MapperProcess mapPE(File errorFile, File logFile) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public MapperProcess mapSE(File errorFile, File logFile) throws IOException {
        throw new IllegalStateException();
    }

    public FileMapping(MapperIndex mapperIndex, FastqFormat fastqFormat, List<String> mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup, GenericLogger logger) {
        super(mapperIndex, fastqFormat, mapperArguments, threadNumber, multipleInstanceEnabled, incrementer, counterGroup, logger);
    }
}

