/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GSNAPMapperProvider
extends AbstractMapperProvider {
    public static final String MAPPER_NAME = "GSNAP";
    private static final String DEFAULT_PACKAGE_VERSION = "2012-07-20";
    private static final String GSNAP_MAPPER_EXECUTABLE = "gsnap";
    private static final String GMAP_MAPPER_EXECUTABLE = "gmap";
    private static final String[] INDEXER_EXECUTABLES = new String[]{"fa_coords", "gmap_process", "gmapindex", "gmap_build"};
    public static final String DEFAULT_ARGUMENTS = "-N 1";
    private static final String SYNC = GSNAPMapperProvider.class.getName();

    @Override
    public String getName() {
        return MAPPER_NAME;
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_PACKAGE_VERSION;
    }

    @Override
    public String getDefaultFlavor() {
        return GSNAP_MAPPER_EXECUTABLE;
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readBinaryVersion(MapperInstance mapperInstance) {
        try {
            String gsnapPath;
            String string = SYNC;
            synchronized (string) {
                gsnapPath = mapperInstance.getExecutor().install(this.flavoredBinary(mapperInstance.getFlavor()));
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{gsnapPath, " --version"});
            String s = MapperUtils.executeToString(mapperInstance.getExecutor(), cmd);
            String[] lines = s.split("\n");
            if (lines.length == 0) {
                return null;
            }
            String[] tokens = lines[0].split(" version ");
            if (tokens.length == 2) {
                return tokens[1];
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Arrays.asList(INDEXER_EXECUTABLES);
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return this.flavoredBinary(mapperInstance.getFlavor());
    }

    @Override
    public boolean checkIfFlavorExists(MapperInstance mapperInstance) {
        switch (mapperInstance.getFlavor().trim().toLowerCase()) {
            case "gsnap": 
            case "gmap": {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getIndexerCommand(File indexerFile, File genomeFile, List<String> indexerArguments, int threads) {
        ArrayList<String> cmd = new ArrayList<String>();
        String binariesDirectory = indexerFile.getParentFile().getAbsolutePath();
        String genomeDirectory = genomeFile.getParentFile().getAbsolutePath();
        cmd.add(indexerFile.getAbsolutePath());
        cmd.add("-B");
        cmd.add(binariesDirectory);
        cmd.add("-D");
        cmd.add(genomeDirectory);
        cmd.add("-d");
        cmd.add("genome");
        cmd.add(genomeFile.getAbsolutePath());
        return cmd;
    }

    private String flavoredBinary(String flavor) {
        if (flavor != null && GMAP_MAPPER_EXECUTABLE.equals(flavor.trim().toLowerCase())) {
            return GMAP_MAPPER_EXECUTABLE;
        }
        return GSNAP_MAPPER_EXECUTABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapSE(EntryMapping mapping, File inputFile, File errorFile, File logFile) throws IOException {
        String gsnapPath;
        String string = SYNC;
        synchronized (string) {
            gsnapPath = mapping.getExecutor().install(this.flavoredBinary(mapping.getFlavor()));
        }
        return this.createMapperProcessSE(mapping, gsnapPath, GSNAPMapperProvider.getGSNAPQualityArgument(mapping.getFastqFormat()), inputFile, errorFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapPE(EntryMapping mapping, File inputFile1, File inputFile2, File errorFile, File logFile) throws IOException {
        String gsnapPath;
        String string = SYNC;
        synchronized (string) {
            gsnapPath = mapping.getExecutor().install(this.flavoredBinary(mapping.getFlavor()));
        }
        return this.createMapperProcessPE(mapping, gsnapPath, GSNAPMapperProvider.getGSNAPQualityArgument(mapping.getFastqFormat()), inputFile1, inputFile2, errorFile);
    }

    private MapperProcess createMapperProcessSE(final EntryMapping mapping, final String gsnapPath, final String fastqFormat, File inputFile, File errorFile) throws IOException {
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(gsnapPath);
                if (GSNAPMapperProvider.GSNAP_MAPPER_EXECUTABLE.equals(GSNAPMapperProvider.this.flavoredBinary(mapping.getFlavor()))) {
                    cmd.add("-A");
                    cmd.add("sam");
                } else {
                    cmd.add("-f");
                    cmd.add("samse");
                }
                cmd.add(fastqFormat);
                cmd.add("-t");
                cmd.add(mapping.getThreadNumber() + "");
                cmd.add("-D");
                cmd.add(mapping.getIndexDirectory().getAbsolutePath());
                cmd.add("-d");
                cmd.add("genome");
                cmd.addAll(mapping.getMapperArguments());
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }

    private MapperProcess createMapperProcessPE(final EntryMapping mapping, final String gsnapPath, final String fastqFormat, File inputFile1, File inputFile2, File errorFile) throws IOException {
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, true, inputFile1, inputFile2){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(gsnapPath);
                if (GSNAPMapperProvider.GSNAP_MAPPER_EXECUTABLE.equals(GSNAPMapperProvider.this.flavoredBinary(mapping.getFlavor()))) {
                    cmd.add("-A");
                    cmd.add("sam");
                } else {
                    cmd.add("-f");
                    cmd.add("sampe");
                }
                cmd.add(fastqFormat);
                cmd.add("-t");
                cmd.add(mapping.getThreadNumber() + "");
                cmd.add("-D");
                cmd.add(mapping.getIndexDirectory().getAbsolutePath());
                cmd.add("-d");
                cmd.add("genome");
                cmd.addAll(mapping.getMapperArguments());
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                cmd.add(this.getNamedPipeFile2().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }

    private static String getGSNAPQualityArgument(FastqFormat format) throws IOException {
        switch (format) {
            case FASTQ_ILLUMINA: {
                return "--quality-protocol=illumina";
            }
            case FASTQ_ILLUMINA_1_5: {
                return "--quality-protocol=illumina";
            }
            case FASTQ_SOLEXA: {
                throw new IOException("GSNAP not handle the Solexa FASTQ format.");
            }
        }
        return "--quality-protocol=sanger";
    }
}

