/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.readmapper.BundledMapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.DockerMapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.PathMapperExecutor;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class Mapper {
    private final MapperProvider provider;
    private final GenericLogger logger;
    private final File tempDir;
    private final File executablesTempDir;
    private final String applicationName;
    private final String applicationVersion;

    public String getName() {
        return this.provider.getName();
    }

    public MapperProvider getProvider() {
        return this.provider;
    }

    public GenericLogger getLogger() {
        return this.logger;
    }

    public File getTemporaryDirectory() {
        return this.tempDir;
    }

    public File getExecutablesTemporaryDirectory() {
        return this.executablesTempDir;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    private String getSoftwarePackage() {
        return this.getName();
    }

    public boolean isIndexGeneratorOnly() {
        return this.provider.isIndexGeneratorOnly();
    }

    public boolean isSplitsAllowed() {
        return this.provider.isSplitsAllowed();
    }

    public boolean isCompressIndex() {
        return this.provider.isCompressedIndex();
    }

    MapperInstance newMapperInstance(String version, String flavor, boolean useBundledBinaries, String dockerImage) throws IOException {
        String versionToUse = Mapper.chooseVersion(version, this.provider.getDefaultVersion());
        String flavorToUse = Mapper.chooseVersion(flavor, this.provider.getDefaultFlavor());
        MapperExecutor executor = this.getExecutor(versionToUse, dockerImage, useBundledBinaries);
        return new MapperInstance(this, executor, versionToUse, flavorToUse, this.getTemporaryDirectory(), this.applicationName, this.logger);
    }

    private MapperExecutor getExecutor(String version, String dockerImage, boolean useBundledBinaries) throws IOException {
        if (dockerImage != null && !dockerImage.isEmpty()) {
            return new DockerMapperExecutor(dockerImage, this.getTemporaryDirectory(), this.logger);
        }
        if (useBundledBinaries) {
            return new BundledMapperExecutor(this.getSoftwarePackage(), version, this.getExecutablesTemporaryDirectory(), this.logger, this.applicationName, this.applicationVersion);
        }
        return new PathMapperExecutor(this.logger);
    }

    private static String chooseVersion(String requiredVersion, String defaultVersion) {
        if (defaultVersion == null) {
            throw new NullPointerException("the defaultVersion argument cannot be null");
        }
        if (requiredVersion == null) {
            return defaultVersion;
        }
        String result = requiredVersion.trim().toLowerCase();
        return result.isEmpty() ? defaultVersion : result;
    }

    Mapper(MapperProvider provider, File tempDir, File executablesTempDir, GenericLogger logger, String applicationName, String applicationVersion) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.provider = provider;
        this.logger = logger;
        this.tempDir = tempDir != null ? tempDir : new File(System.getProperty("java.io.tmpdir"));
        this.executablesTempDir = executablesTempDir != null ? executablesTempDir : this.tempDir;
        this.applicationName = applicationName != null ? applicationName : "UnknownApplication";
        this.applicationVersion = applicationVersion != null ? applicationVersion : "UnknownVersion";
    }
}

