/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProviderService;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.File;
import java.util.Objects;

public class MapperBuilder {
    private final String mapperName;
    private GenericLogger logger = new DummyLogger();
    private String applicationName = "kenetre";
    private String applicationVersion = "unknown";
    private File tempDir = new File(System.getProperty("java.io.tmpdir"));
    private File executablesTempDir = new File(System.getProperty("java.io.tmpdir"));

    public MapperBuilder withLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
        return this;
    }

    public MapperBuilder withApplicationName(String applicationName) {
        Objects.requireNonNull(applicationName);
        this.applicationName = applicationName;
        return this;
    }

    public MapperBuilder withApplicationVersion(String applicationVersion) {
        Objects.requireNonNull(applicationVersion);
        this.applicationVersion = applicationVersion;
        return this;
    }

    public MapperBuilder withTempDirectory(File tempDir) {
        Objects.requireNonNull(tempDir);
        this.tempDir = tempDir;
        return this;
    }

    public MapperBuilder withExecutablesTempDirectory(File executablesTempDir) {
        Objects.requireNonNull(executablesTempDir);
        this.executablesTempDir = executablesTempDir;
        return this;
    }

    public Mapper build() {
        MapperProvider provider = (MapperProvider)MapperProviderService.getInstance().newService(this.mapperName);
        if (provider == null) {
            this.logger.error("Unknown mapper: " + this.mapperName);
            return null;
        }
        return new Mapper(provider, this.tempDir, this.executablesTempDir, this.logger, this.applicationName, this.applicationVersion);
    }

    public MapperBuilder(String mapperName) {
        Objects.requireNonNull(mapperName);
        this.mapperName = mapperName;
    }

    public MapperBuilder(Mapper mapper) {
        Objects.requireNonNull(mapper);
        this.mapperName = mapper.getName();
        this.logger = mapper.getLogger();
        this.applicationName = mapper.getApplicationName();
        this.applicationVersion = mapper.getApplicationVersion();
        this.tempDir = mapper.getTemporaryDirectory();
        this.executablesTempDir = mapper.getExecutablesTemporaryDirectory();
    }
}

