/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.FileMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.Objects;

public class MapperIndex {
    private final MapperInstance mapperInstance;
    private final InputStream in;
    private final File indexDirectory;
    private final GenericLogger logger;
    private boolean unzipped;

    MapperInstance getMapperInstance() {
        return this.mapperInstance;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    private InputStream getInputStream() {
        return this.in;
    }

    String getMapperName() {
        return this.getMapperInstance().getMapper().getName();
    }

    public EntryMapping newEntryMapping(FastqFormat fastqFormat, String mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup) throws IOException {
        return this.newEntryMapping(fastqFormat, MapperUtils.argumentsAsList(mapperArguments), threadNumber, multipleInstanceEnabled, incrementer, counterGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryMapping newEntryMapping(FastqFormat fastqFormat, List<String> mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup) throws IOException {
        MapperIndex mapperIndex = this;
        synchronized (mapperIndex) {
            if (!this.unzipped) {
                this.unzipArchiveIndexFile(this.getInputStream(), this.getIndexDirectory());
                this.unzipped = false;
            }
        }
        return new EntryMapping(this, fastqFormat, mapperArguments, threadNumber, multipleInstanceEnabled, incrementer, counterGroup, this.logger);
    }

    public FileMapping newFileMapping(FastqFormat fastqFormat, String mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup) throws IOException {
        return this.newFileMapping(fastqFormat, MapperUtils.argumentsAsList(mapperArguments), threadNumber, multipleInstanceEnabled, incrementer, counterGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMapping newFileMapping(FastqFormat fastqFormat, List<String> mapperArguments, int threadNumber, boolean multipleInstanceEnabled, ReporterIncrementer incrementer, String counterGroup) throws IOException {
        MapperIndex mapperIndex = this;
        synchronized (mapperIndex) {
            if (!this.unzipped) {
                this.unzipArchiveIndexFile(this.getInputStream(), this.getIndexDirectory());
                this.unzipped = false;
            }
        }
        return new FileMapping(this, fastqFormat, mapperArguments, threadNumber, multipleInstanceEnabled, incrementer, counterGroup, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipArchiveIndexFile(InputStream archiveIndexFile, File archiveIndexDir) throws IOException {
        File lockFile = new File(archiveIndexDir.getAbsoluteFile().getParentFile(), archiveIndexDir.getName() + ".lock");
        RandomAccessFile lockIs = new RandomAccessFile(lockFile, "rw");
        FileLock lock = lockIs.getChannel().lock();
        try {
            if (!archiveIndexDir.exists()) {
                if (!archiveIndexDir.mkdir()) {
                    throw new IOException("Can't create directory for " + this.getMapperName() + " index: " + archiveIndexDir);
                }
                this.logger.debug("Unzip archiveIndexFile in " + archiveIndexDir);
                FileUtils.unzip((InputStream)archiveIndexFile, (File)archiveIndexDir);
            }
        }
        finally {
            lock.release();
            lockIs.close();
            lockFile.delete();
        }
        FileUtils.checkExistingDirectoryFile((File)archiveIndexDir, (String)(this.getMapperName() + " index directory"));
    }

    MapperIndex(MapperInstance mapperInstance, InputStream archiveIndexFileInputStream, File indexOutputDirectory, GenericLogger logger) {
        Objects.requireNonNull(mapperInstance, "mapperInstance cannot be null");
        Objects.requireNonNull(archiveIndexFileInputStream, "archiveIndexFileInputStream cannot be null");
        Objects.requireNonNull(indexOutputDirectory, "archiveIndexDir cannot be null");
        this.mapperInstance = mapperInstance;
        this.in = archiveIndexFileInputStream;
        this.indexDirectory = indexOutputDirectory;
        this.logger = logger;
    }
}

