/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperIndex;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MapperInstance {
    private static final String SYNC = MapperInstance.class.getName();
    private final Mapper mapper;
    private final MapperExecutor executor;
    private final String version;
    private final String flavor;
    private final File temporaryDirectory;
    private final GenericLogger logger;
    private final String applicationName;
    private boolean mapperInstalled;

    public String getName() {
        return this.mapper.getName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    private MapperProvider getProvider() {
        return this.mapper.getProvider();
    }

    public MapperExecutor getExecutor() {
        return this.executor;
    }

    public void makeArchiveIndex(InputStream genomeIs, File archiveOutputFile, String indexerArguments, int threads) throws IOException {
        this.makeArchiveIndex(genomeIs, archiveOutputFile, MapperUtils.argumentsAsList(indexerArguments), threads);
    }

    public void makeArchiveIndex(InputStream genomeIs, File archiveOutputFile, List<String> indexerArguments, int threads) throws IOException {
        Objects.requireNonNull(genomeIs, "Input steam is null");
        Objects.requireNonNull(archiveOutputFile, "Archive output file is null");
        this.logger.debug("Copy genome to local disk before computing index");
        File genomeTmpFile = File.createTempFile(this.applicationName + "-genome", ".fasta", this.getTemporaryDirectory());
        FileUtils.copy((InputStream)genomeIs, (OutputStream)FileUtils.createOutputStream((File)genomeTmpFile));
        this.makeArchiveIndex(genomeTmpFile, archiveOutputFile, indexerArguments, threads);
        if (!genomeTmpFile.delete()) {
            this.logger.warn("Cannot delete temporary index zip file");
        }
    }

    public void makeArchiveIndex(File genomeFile, File archiveOutputFile, String indexerArguments, int threads) throws IOException {
        this.makeArchiveIndex(genomeFile, archiveOutputFile, MapperUtils.argumentsAsList(indexerArguments), threads);
    }

    public void makeArchiveIndex(File genomeFile, File archiveOutputFile, List<String> indexerArguments, int threads) throws IOException {
        this.logger.debug("Start index computation");
        String indexTmpDirPrefix = this.applicationName + "-" + this.mapper.getName().toLowerCase() + "-genomeindexdir-";
        this.logger.debug("Want to create a temporary directory with prefix: " + indexTmpDirPrefix + " in " + this.getTemporaryDirectory());
        File indexCreationDir = Files.createTempDirectory(this.getTemporaryDirectory().toPath(), indexTmpDirPrefix, new FileAttribute[0]).toFile();
        File unCompressedGenomeFile = MapperInstance.uncompressGenomeIfNecessary(genomeFile, indexCreationDir, this.logger);
        File outputDir = archiveOutputFile.getParentFile();
        String basename = StringUtils.basename((String)archiveOutputFile.getName());
        File stdoutFile = new File(outputDir, basename + ".out");
        File stderrFile = new File(outputDir, basename + ".err");
        this.computeIndex(unCompressedGenomeFile, indexCreationDir, indexerArguments, threads, stdoutFile, stderrFile);
        FileUtils.createZip((File)indexCreationDir, (File)archiveOutputFile, (!this.mapper.isCompressIndex() ? 1 : 0) != 0);
        FileUtils.removeDirectory((File)indexCreationDir);
        this.logger.debug("End index computation");
    }

    private void computeIndex(File genomeFile, File outputDir, List<String> indexerArguments, int threads, File stdOutFile, File stdErrorFile) throws IOException {
        int exitValue;
        Objects.requireNonNull(genomeFile, "genome file is null");
        Objects.requireNonNull(outputDir, "output directory is null");
        this.logger.debug("Start computing " + this.mapper.getName() + " index for " + genomeFile);
        long startTime = System.currentTimeMillis();
        File indexer = new File(this.installIndexer());
        if (!outputDir.exists() && !outputDir.mkdir()) {
            throw new IOException("Unable to create directory for genome index");
        }
        File tmpGenomeFile = new File(outputDir, genomeFile.getName());
        if (!genomeFile.equals(tmpGenomeFile)) {
            try {
                Files.createSymbolicLink(tmpGenomeFile.toPath(), genomeFile.getAbsoluteFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Unable to create the symbolic link in " + tmpGenomeFile + " directory for " + genomeFile);
            }
        }
        ArrayList<String> cmd = new ArrayList<String>(this.mapper.getProvider().getIndexerCommand(indexer, tmpGenomeFile, indexerArguments, threads));
        this.logger.debug(((Object)cmd).toString());
        MapperExecutor.Result result = this.executor.execute(cmd, tmpGenomeFile.getParentFile(), false, stdErrorFile, false, genomeFile, tmpGenomeFile);
        if (stdOutFile != null) {
            FileUtils.copy((InputStream)result.getInputStream(), (OutputStream)new FileOutputStream(stdOutFile));
        }
        if ((exitValue = result.waitFor()) != 0) {
            throw new IOException("Bad error result for index creation execution: " + exitValue);
        }
        if (!tmpGenomeFile.delete()) {
            this.logger.warn("Cannot remove symbolic link while after creating " + this.mapper.getName() + " index");
        }
        long endTime = System.currentTimeMillis();
        this.logger.debug("Create the " + this.mapper.getName() + " index in " + StringUtils.toTimeHumanReadable((long)(endTime - startTime)));
    }

    private static File uncompressGenomeIfNecessary(File genomeFile, File outputDir, GenericLogger logger) throws IOException {
        CompressionType ct = CompressionType.getCompressionTypeByFilename((String)genomeFile.getName());
        if (ct == CompressionType.NONE) {
            return genomeFile;
        }
        File uncompressFile = new File(outputDir, StringUtils.filenameWithoutCompressionExtension((String)genomeFile.getName()));
        logger.debug("Uncompress genome " + genomeFile + " to " + uncompressFile);
        InputStream in = ct.createInputStream(FileUtils.createInputStream((File)genomeFile));
        OutputStream out = FileUtils.createOutputStream((File)uncompressFile);
        FileUtils.copy((InputStream)in, (OutputStream)out);
        return uncompressFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installIndexer() throws IOException {
        String result = null;
        String string = SYNC;
        synchronized (string) {
            for (String indexer : this.getProvider().getIndexerExecutables(this)) {
                result = this.executor.install(indexer);
            }
        }
        if (result == null) {
            throw new IOException("No indexer executable found for mapper: " + this.getMapper().getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installMapper() throws IOException {
        if (this.mapperInstalled) {
            return;
        }
        String string = SYNC;
        synchronized (string) {
            this.executor.install(this.getProvider().getMapperExecutableName(this));
            this.mapperInstalled = true;
        }
    }

    private boolean checkIfBinaryExists(MapperExecutor executor, List<String> binaryFilenames) throws IOException {
        if (binaryFilenames == null || binaryFilenames.isEmpty()) {
            return false;
        }
        for (String binaryFilename : binaryFilenames) {
            if (this.checkIfBinaryExists(executor, binaryFilename)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfBinaryExists(MapperExecutor executor, String binaryFilename) throws IOException {
        return executor.isExecutable(binaryFilename);
    }

    private void checkMapperBinaries() throws IOException {
        if (!this.checkIfBinaryExists(this.executor, this.getProvider().getIndexerExecutables(this))) {
            throw new IOException("Unable to find mapper " + this.mapper.getName() + " version " + this.version + " (flavor: " + (this.flavor == null ? "not defined" : this.flavor) + ")");
        }
        if (!this.checkIfBinaryExists(this.executor, this.getProvider().getMapperExecutableName(this))) {
            throw new IOException("Unable to find mapper " + this.mapper.getName() + " version " + this.version + " (flavor: " + (this.flavor == null ? "not defined" : this.flavor) + ")");
        }
        if (!this.getProvider().checkIfFlavorExists(this)) {
            throw new IOException("Unable to find mapper " + this.mapper.getName() + " version " + this.version + " (flavor: " + (this.flavor == null ? "not defined" : this.flavor) + ")");
        }
    }

    public String getBinaryVersion() {
        if (!this.mapperInstalled) {
            // empty if block
        }
        return this.getProvider().readBinaryVersion(this);
    }

    public MapperIndex newMapperIndex(File archiveIndexFile, File indexOutputDir) throws IOException {
        return new MapperIndex(this, new FileInputStream(archiveIndexFile), indexOutputDir, this.logger);
    }

    public MapperIndex newMapperIndex(InputStream in, File indexOutputDir) throws IOException {
        this.installMapper();
        return new MapperIndex(this, in, indexOutputDir, this.logger);
    }

    MapperInstance(Mapper mapper, MapperExecutor executor, String version, String flavor, File temporaryDirectory, String applicationName, GenericLogger logger) throws IOException {
        Objects.requireNonNull(mapper, "mapper cannot be null");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(temporaryDirectory, "temporaryDirectory cannot be null");
        Objects.requireNonNull(applicationName, "applicationName cannot be null");
        this.mapper = mapper;
        this.executor = executor;
        this.version = version;
        this.flavor = flavor;
        this.temporaryDirectory = temporaryDirectory;
        this.applicationName = applicationName;
        this.logger = logger == null ? new DummyLogger() : logger;
        this.logger.debug("Use executor: " + this.executor);
        this.checkMapperBinaries();
    }
}

