/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import java.io.IOException;
import java.util.Objects;

public class MapperInstanceBuilder {
    private final Mapper mapper;
    private String mapperVersion;
    private String mapperFlavor;
    private boolean useBundledBinaries;
    private String dockerImage;

    public MapperInstanceBuilder withMapperVersion(String mapperVersion) {
        this.mapperVersion = mapperVersion;
        return this;
    }

    public MapperInstanceBuilder withMapperFlavor(String mapperFlavor) {
        this.mapperFlavor = mapperFlavor;
        return this;
    }

    public MapperInstanceBuilder withUseBundledBinaries(boolean useBundledBinaries) {
        this.useBundledBinaries = useBundledBinaries;
        return this;
    }

    public MapperInstanceBuilder withDockerImage(String dockerImage) {
        Objects.requireNonNull(dockerImage);
        this.dockerImage = dockerImage;
        return this;
    }

    public MapperInstance build() throws IOException {
        return this.mapper.newMapperInstance(this.mapperVersion, this.mapperFlavor, this.useBundledBinaries, this.dockerImage);
    }

    public MapperInstanceBuilder(Mapper mapper) {
        Objects.requireNonNull(mapper);
        this.mapper = mapper;
    }
}

