/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MapperUtils {
    public static String executeToString(MapperExecutor executor, List<String> command) throws IOException {
        Objects.requireNonNull(executor, "executor argument cannot be null");
        Objects.requireNonNull(command, "command argument cannot be null");
        MapperExecutor.Result result = executor.execute(command, null, true, null, true, new File[0]);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(result.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static File getIndexPath(String mapperName, File indexDirectory, String extension, int extensionLength) throws IOException {
        Objects.requireNonNull(mapperName, "mapperName argument cannot be null");
        Objects.requireNonNull(indexDirectory, "indexDirectory argument cannot be null");
        Objects.requireNonNull(extension, "extension argument cannot be null");
        File[] indexFiles = FileUtils.listFilesByExtension((File)indexDirectory, (String)extension);
        if (indexFiles == null || indexFiles.length == 0) {
            throw new IOException("Unable to get index file for " + mapperName + " with \"" + extension + "\" extension in directory: " + indexDirectory);
        }
        if (indexFiles.length > 1) {
            throw new IOException("More than one index file for " + mapperName + " with \"" + extension + "\" extension in directory: " + indexDirectory);
        }
        String bwtFile = indexFiles[0].getAbsolutePath();
        return new File(bwtFile.substring(0, bwtFile.length() - extensionLength));
    }

    public static List<String> argumentsAsList(String s) {
        if (s == null) {
            return Collections.emptyList();
        }
        String[] tabMapperArguments = s.trim().split(" ");
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : tabMapperArguments) {
            if (arg.isEmpty()) continue;
            result.add(arg);
        }
        return result;
    }
}

