/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import com.google.common.base.Strings;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.FileDataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeIndexStorage;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;

public abstract class AbstractFileGenomeIndexStorage
implements GenomeIndexStorage {
    private static final String INDEX_FILENAME = "genomes_index_storage.txt";
    private final DataPath dir;
    private final Map<String, IndexEntry> entries = new LinkedHashMap<String, IndexEntry>();
    private final GenericLogger logger;

    protected abstract DataPath newDataPath(String var1);

    protected abstract DataPath newDataPath(DataPath var1, String var2);

    protected DataPath getDataPath(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription) {
        Objects.requireNonNull(mapperInstance, "Mapper is null");
        Objects.requireNonNull(genome, "Genome description is null");
        Objects.requireNonNull(additionalDescription, "additionalDescription is null");
        IndexEntry entry = this.entries.get(AbstractFileGenomeIndexStorage.createKey(mapperInstance, genome, additionalDescription, this.logger));
        return entry == null ? null : this.newDataPath(this.dir, entry.fileName);
    }

    protected void put(MapperInstance mapper, GenomeDescription genome, Map<String, String> additionalDescription, DataPath indexArchive) {
        Objects.requireNonNull(mapper, "Mapper is null");
        Objects.requireNonNull(genome, "Genome description is null");
        Objects.requireNonNull(additionalDescription, "additionalDescription is null");
        Objects.requireNonNull(indexArchive, "IndexArchive is null");
        try {
            this.load();
        }
        catch (IOException e1) {
            this.logger.warn("Unable to reload the index mapper storage");
        }
        if (!indexArchive.exists()) {
            return;
        }
        String key = AbstractFileGenomeIndexStorage.createKey(mapper, genome, additionalDescription, this.logger);
        if (this.entries.containsKey(key)) {
            return;
        }
        IndexEntry entry = this.createIndexEntry(mapper, genome, additionalDescription);
        if (entry == null) {
            return;
        }
        try {
            FileUtils.copy((InputStream)indexArchive.rawOpen(), (OutputStream)this.newDataPath(this.dir, entry.fileName).create());
            this.entries.put(entry.getKey(), entry);
            this.save();
            this.logger.info("Successfully added " + indexArchive.getName() + " index archive to genome index storage.");
        }
        catch (IOException e) {
            this.logger.warn("Failed to add " + indexArchive.getName() + " index archive to genome index storage: " + e.getMessage());
        }
    }

    @Override
    public File get(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription) {
        DataPath result = this.getDataPath(mapperInstance, genome, additionalDescription);
        return result == null ? null : result.toFile();
    }

    @Override
    public void put(MapperInstance mapper, GenomeDescription genome, Map<String, String> additionalDescription, File indexArchive) {
        Objects.requireNonNull(indexArchive, "IndexArchive is null");
        this.put(mapper, genome, additionalDescription, new FileDataPath(indexArchive));
    }

    private IndexEntry createIndexEntry(MapperInstance mapper, GenomeDescription genome, Map<String, String> additionalDescription) {
        IndexEntry entry = new IndexEntry();
        entry.genomeName = genome.getGenomeName().trim();
        entry.sequences = genome.getSequenceCount();
        entry.length = genome.getGenomeLength();
        entry.mapperName = mapper.getName().toLowerCase().trim();
        Map<String, String> md5Map = AbstractFileGenomeIndexStorage.createMD5SumMap(mapper, genome, additionalDescription);
        String md5Sum = AbstractFileGenomeIndexStorage.createMD5Sum(md5Map, this.logger);
        if (md5Sum == null) {
            return null;
        }
        entry.genomeMD5 = md5Sum;
        entry.fileName = entry.mapperName + "-" + entry.genomeMD5 + ".zip";
        entry.description = md5Map.toString();
        return entry;
    }

    private static Map<String, String> createMD5SumMap(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("mapper.name", Strings.nullToEmpty((String)mapperInstance.getName()));
        map.put("mapper.version", Strings.nullToEmpty((String)mapperInstance.getVersion()).trim());
        map.put("mapper.flavor", Strings.nullToEmpty((String)mapperInstance.getFlavor()).trim());
        map.put("genome.md5sum", Strings.nullToEmpty((String)genome.getMD5Sum()).trim());
        map.putAll(new TreeMap<String, String>(additionalDescription));
        return map;
    }

    private static String createMD5Sum(Map<String, String> map, GenericLogger logger) {
        MessageDigest md5Digest;
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Failled to create checksum for mapper index: " + e.getMessage());
            return null;
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            md5Digest.update(e.getKey().getBytes(Charset.defaultCharset()));
            md5Digest.update(e.getValue().getBytes(Charset.defaultCharset()));
        }
        return StringUtils.md5DigestToString((MessageDigest)md5Digest);
    }

    private void load() throws IOException {
        if (!this.dir.exists()) {
            throw new IOException("Genome index storage directory not found: " + this.dir.getSource());
        }
        DataPath indexFile = this.newDataPath(this.dir, INDEX_FILENAME);
        if (!indexFile.exists()) {
            this.save();
            return;
        }
        this.entries.clear();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(indexFile.open(), Charset.defaultCharset()));){
            Pattern pattern = Pattern.compile("\t");
            String line = null;
            while ((line = br.readLine()) != null) {
                List<String> fields;
                String trimmedLine = line.trim();
                if ("".equals(trimmedLine) || trimmedLine.startsWith("#") || (fields = Arrays.asList(pattern.split(trimmedLine))).size() < 6 || fields.size() > 7) continue;
                IndexEntry e = new IndexEntry();
                e.genomeName = fields.get(0);
                e.genomeMD5 = fields.get(1);
                e.mapperName = fields.get(4);
                e.fileName = fields.get(5);
                if (this.newDataPath(this.dir, e.fileName).exists()) {
                    this.entries.put(e.getKey(), e);
                }
                if (fields.size() != 7) continue;
                e.description = fields.get(6);
            }
        }
    }

    private void save() throws IOException {
        if (!this.dir.exists()) {
            throw new IOException("Genome index storage directory not found: " + this.dir.getSource());
        }
        DataPath indexFile = this.newDataPath(this.dir, INDEX_FILENAME);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(indexFile.create(), Charset.defaultCharset()));){
            writer.write("#Genome\tChecksum\tGenomeSequences\tGenomeLength\tMapper\tIndexFile\tDescription\n");
            for (Map.Entry<String, IndexEntry> e : this.entries.entrySet()) {
                IndexEntry ie = e.getValue();
                writer.append(ie.genomeName == null ? "???" : ie.genomeName);
                writer.append("\t");
                writer.append(ie.genomeMD5);
                writer.append("\t");
                writer.append(Integer.toString(ie.sequences));
                writer.append("\t");
                writer.append(Long.toString(ie.length));
                writer.append("\t");
                writer.append(ie.mapperName);
                writer.append("\t");
                writer.append(ie.fileName);
                if (ie.description != null) {
                    writer.append("\t");
                    writer.append(ie.description);
                }
                writer.append("\n");
            }
        }
    }

    private static String createKey(MapperInstance mapperInstance, GenomeDescription genome, Map<String, String> additionalDescription, GenericLogger logger) {
        return AbstractFileGenomeIndexStorage.createKey(mapperInstance.getName(), AbstractFileGenomeIndexStorage.createMD5Sum(AbstractFileGenomeIndexStorage.createMD5SumMap(mapperInstance, genome, additionalDescription), logger));
    }

    private static String createKey(String mapperName, String genomeMD5) {
        return mapperName.toLowerCase().trim() + '\t' + genomeMD5;
    }

    protected AbstractFileGenomeIndexStorage(DataPath dir, GenericLogger logger) throws IOException {
        Objects.requireNonNull(dir, "Index directory is null");
        this.dir = dir;
        this.logger = logger != null ? logger : new DummyLogger();
        this.load();
        this.logger.info("Genome index storage found." + this.entries.size() + " entries in : " + dir.getSource());
    }

    private static final class IndexEntry {
        String genomeName;
        int sequences;
        long length;
        String genomeMD5;
        String mapperName;
        String fileName;
        String description;

        private IndexEntry() {
        }

        String getKey() {
            return AbstractFileGenomeIndexStorage.createKey(this.mapperName, this.genomeMD5);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{genomeName=" + this.genomeName + ", sequences=" + this.sequences + ", length=" + this.length + ", genomeMD5=" + this.genomeMD5 + ", mapperName= " + this.mapperName + ", fileName=" + this.fileName + "}";
        }
    }
}

