/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.AbstractFileGenomeIndexStorage;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.FileDataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeIndexStorage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class FileGenomeMapperIndexer {
    private final MapperInstance mapperInstance;
    private final AbstractFileGenomeIndexStorage storage;
    private final String indexerArguments;
    private final int threads;
    private final LinkedHashMap<String, String> additionalDescription;
    private final File temporaryDirectory;
    private final GenericLogger logger;

    public void createIndex(File genomePath, GenomeDescription genomeDescription, File mapperIndexPath) throws IOException {
        Objects.requireNonNull(genomePath);
        Objects.requireNonNull(genomePath);
        this.createIndex(new FileDataPath(genomePath), genomeDescription, new FileDataPath(mapperIndexPath));
    }

    protected void createIndex(DataPath genomeDataFile, GenomeDescription genomeDescription, DataPath mapperIndexDataFile) throws IOException {
        Objects.requireNonNull(genomeDataFile);
        Objects.requireNonNull(genomeDescription);
        Objects.requireNonNull(mapperIndexDataFile);
        this.logger.info("Mapper name: " + this.mapperInstance.getName());
        this.logger.info("Mapper version: " + this.mapperInstance.getVersion());
        this.logger.info("Mapper flavor: " + this.mapperInstance.getFlavor());
        this.logger.info("Indexer arguments: " + this.indexerArguments);
        DataPath precomputedIndexDataFile = this.storage == null ? null : this.storage.getDataPath(this.mapperInstance, genomeDescription, this.additionalDescription);
        if (precomputedIndexDataFile == null) {
            this.logger.info("Mapper index not found, must compute it");
            this.computeIndex(genomeDataFile, mapperIndexDataFile);
            if (this.storage != null) {
                this.storage.put(this.mapperInstance, genomeDescription, this.additionalDescription, mapperIndexDataFile);
            }
        } else {
            this.logger.info("Mapper index found, no need to recompute it (mapper index file: " + precomputedIndexDataFile + ")");
            this.logger.info("Copy or create a symbolic link for the mapper index file (Created file or symbolic link: " + mapperIndexDataFile + ")");
            precomputedIndexDataFile.symlinkOrCopy(mapperIndexDataFile);
        }
    }

    private void computeIndex(DataPath genome, DataPath mapperIndex) throws IOException {
        File outputFile = mapperIndex.toFile();
        if (outputFile == null) {
            outputFile = File.createTempFile(this.mapperInstance.getName() + "-index-archive-", ".zip", this.temporaryDirectory);
        }
        if (genome.toFile() != null) {
            this.mapperInstance.makeArchiveIndex(genome.toFile(), outputFile, this.indexerArguments, this.threads);
        } else {
            this.mapperInstance.makeArchiveIndex(genome.open(), outputFile, this.indexerArguments, this.threads);
        }
        this.logger.info("mapperIndexDataFile: " + mapperIndex);
        if (mapperIndex.toFile() == null) {
            new FileDataPath(outputFile).copy(mapperIndex);
            if (!outputFile.delete()) {
                this.logger.error("Unable to delete temporary " + this.mapperInstance.getName() + " archive index.");
            }
        }
    }

    public FileGenomeMapperIndexer(MapperInstance mapperInstance, String additionalArguments, Map<String, String> additionalDescription, int threads, GenomeIndexStorage storage, File temporaryDirectory, GenericLogger logger) {
        Objects.requireNonNull(mapperInstance, "Mapper is null");
        Objects.requireNonNull(additionalDescription, "additionalDescription is null");
        this.mapperInstance = mapperInstance;
        if (storage != null) {
            if (!(storage instanceof AbstractFileGenomeIndexStorage)) {
                throw new IllegalArgumentException("storage must be an instance of AbstractGenomeIndexStorage");
            }
            this.storage = (AbstractFileGenomeIndexStorage)storage;
        } else {
            this.storage = null;
        }
        this.indexerArguments = additionalArguments == null || additionalArguments.trim().isEmpty() ? "" : additionalArguments;
        this.threads = threads;
        this.additionalDescription = new LinkedHashMap<String, String>(additionalDescription);
        this.temporaryDirectory = temporaryDirectory != null ? temporaryDirectory : new File(System.getProperty("java.io.tmpdir"));
        this.logger = logger == null ? new DummyLogger() : logger;
    }
}

