/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import uk.ac.babraham.FastQC.Dialogs.AboutDialog;
import uk.ac.babraham.FastQC.FastQCApplication;
import uk.ac.babraham.FastQC.Help.HelpDialog;

public class FastQCMenuBar
extends JMenuBar
implements ActionListener {
    private FastQCApplication application;

    public FastQCMenuBar(FastQCApplication application) {
        this.application = application;
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem fileOpen = new JMenuItem("Open...");
        fileOpen.setMnemonic(79);
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileOpen.setActionCommand("open");
        fileOpen.addActionListener(this);
        fileMenu.add(fileOpen);
        fileMenu.addSeparator();
        JMenuItem fileSave = new JMenuItem("Save report...");
        fileSave.setMnemonic(83);
        fileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileSave.setActionCommand("save");
        fileSave.addActionListener(this);
        fileMenu.add(fileSave);
        fileMenu.addSeparator();
        JMenuItem fileClose = new JMenuItem("Close");
        fileClose.setMnemonic(67);
        fileClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileClose.setActionCommand("close");
        fileClose.addActionListener(this);
        fileMenu.add(fileClose);
        JMenuItem fileCloseAll = new JMenuItem("Close All");
        fileCloseAll.setMnemonic(65);
        fileCloseAll.setActionCommand("close_all");
        fileCloseAll.addActionListener(this);
        fileMenu.add(fileCloseAll);
        fileMenu.addSeparator();
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic(88);
        fileExit.setActionCommand("exit");
        fileExit.addActionListener(this);
        fileMenu.add(fileExit);
        this.add(fileMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem helpContents = new JMenuItem("Contents...");
        helpContents.setMnemonic(67);
        helpContents.setActionCommand("help_contents");
        helpContents.addActionListener(this);
        helpMenu.add(helpContents);
        helpMenu.addSeparator();
        JMenuItem helpAbout = new JMenuItem("About FastQC");
        helpAbout.setMnemonic(65);
        helpAbout.setActionCommand("about");
        helpAbout.addActionListener(this);
        helpMenu.add(helpAbout);
        this.add(helpMenu);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("exit")) {
            System.exit(0);
        } else if (command.equals("open")) {
            this.application.openFile();
        } else if (command.equals("save")) {
            this.application.saveReport();
        } else if (command.equals("close")) {
            this.application.close();
        } else if (command.equals("close_all")) {
            this.application.closeAll();
        } else if (command.equals("help_contents")) {
            try {
                new HelpDialog(this.application, new File(URLDecoder.decode(ClassLoader.getSystemResource("Help").getFile(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        } else if (command.equals("about")) {
            new AboutDialog(this.application);
        } else {
            JOptionPane.showMessageDialog(this.application, "Unknown menu command " + command, "Unknown command", 0);
        }
    }
}

