/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.babraham.FastQC.Help;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpPage
extends DefaultMutableTreeNode {
    private File file;
    private String name;

    public HelpPage(File file) {
        this.file = file;
        this.name = file.getName();
        this.name = this.name.replaceFirst("\\.[hH][tT][mM][lL]?$", "");
        String[] nameSections = this.name.split(" ");
        if (nameSections.length > 1) {
            String[] numbers = nameSections[0].split("\\.");
            int n = 0;
            while (n < numbers.length) {
                try {
                    Integer.parseInt(numbers[n]);
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                ++n;
            }
            StringBuffer sb = new StringBuffer(nameSections[1]);
            int s = 2;
            while (s < nameSections.length) {
                sb.append(" ");
                sb.append(nameSections[s]);
                ++s;
            }
            this.name = sb.toString();
        }
    }

    public void containsString(String searchTerm, Vector<HelpPage> hits) throws IOException {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isLeaf()) {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            searchTerm = searchTerm.toLowerCase();
            while ((line = br.readLine()) != null) {
                if (line.toLowerCase().indexOf(searchTerm) == -1) continue;
                hits.add(this);
                break;
            }
        }
        Enumeration<TreeNode> kids = this.children();
        while (kids.hasMoreElements()) {
            TreeNode node = kids.nextElement();
            if (!(node instanceof HelpPage)) continue;
            ((HelpPage)node).containsString(searchTerm, hits);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isLeaf() {
        return !this.file.isDirectory();
    }

    public File getFile() {
        return this.file;
    }
}

